/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.convert.FromString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BasePeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public class MutablePeriod
extends BasePeriod
implements ReadWritablePeriod,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3436451121567212165L;

    public void setHours(int arg0) {
        super.setField(DurationFieldType.hours(), arg0);
    }

    public int getDays() {
        return this.getPeriodType().getIndexedField(this, PeriodType.DAY_INDEX);
    }

    public void setPeriod(ReadableInstant arg0, ReadableInstant arg1) {
        if (arg0 == arg1) {
            this.setPeriod(0L);
        } else {
            long l2 = DateTimeUtils.getInstantMillis(arg0);
            long l3 = DateTimeUtils.getInstantMillis(arg1);
            Chronology chronology = DateTimeUtils.getIntervalChronology(arg0, arg1);
            this.setPeriod(l2, l3, chronology);
        }
    }

    public void addHours(int arg0) {
        super.addField(DurationFieldType.hours(), arg0);
    }

    public void setWeeks(int arg0) {
        super.setField(DurationFieldType.weeks(), arg0);
    }

    public void setPeriod(ReadableInterval arg0) {
        if (arg0 == null) {
            this.setPeriod(0L);
        } else {
            Chronology chronology = DateTimeUtils.getChronology(arg0.getChronology());
            this.setPeriod(arg0.getStartMillis(), arg0.getEndMillis(), chronology);
        }
    }

    public void setDays(int arg0) {
        super.setField(DurationFieldType.days(), arg0);
    }

    public MutablePeriod(long arg0, Chronology arg1) {
        super(arg0, (PeriodType)null, arg1);
    }

    public MutablePeriod copy() {
        return (MutablePeriod)this.clone();
    }

    public int getMonths() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MONTH_INDEX);
    }

    public void setPeriod(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7) {
        super.setPeriod(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public MutablePeriod(ReadableInstant arg0, ReadableInstant arg1, PeriodType arg2) {
        super(arg0, arg1, arg2);
    }

    public void mergePeriod(ReadablePeriod arg0) {
        super.mergePeriod(arg0);
    }

    public void add(DurationFieldType arg0, int arg1) {
        super.addField(arg0, arg1);
    }

    public MutablePeriod(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7) {
        super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, PeriodType.standard());
    }

    public void add(long arg0, Chronology arg1) {
        this.add(new Period(arg0, this.getPeriodType(), arg1));
    }

    public void add(long arg0) {
        this.add(new Period(arg0, this.getPeriodType()));
    }

    public MutablePeriod(Object arg0, Chronology arg1) {
        super(arg0, null, arg1);
    }

    public void setMinutes(int arg0) {
        super.setField(DurationFieldType.minutes(), arg0);
    }

    public void add(ReadablePeriod arg0) {
        super.addPeriod(arg0);
    }

    public MutablePeriod(PeriodType arg0) {
        super(0L, arg0, (Chronology)null);
    }

    public void addMonths(int arg0) {
        super.addField(DurationFieldType.months(), arg0);
    }

    public int getSeconds() {
        return this.getPeriodType().getIndexedField(this, PeriodType.SECOND_INDEX);
    }

    public int getMillis() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MILLI_INDEX);
    }

    public MutablePeriod(ReadableInstant arg0, ReadableDuration arg1) {
        super(arg0, arg1, null);
    }

    public void setPeriod(ReadableDuration arg0, Chronology arg1) {
        long l2 = DateTimeUtils.getDurationMillis(arg0);
        this.setPeriod(l2, arg1);
    }

    public int getWeeks() {
        return this.getPeriodType().getIndexedField(this, PeriodType.WEEK_INDEX);
    }

    public void setPeriod(long arg0) {
        this.setPeriod(arg0, null);
    }

    public void add(ReadableInterval arg0) {
        if (arg0 != null) {
            this.add(arg0.toPeriod(this.getPeriodType()));
        }
    }

    public void setYears(int arg0) {
        super.setField(DurationFieldType.years(), arg0);
    }

    public void setPeriod(ReadableDuration arg0) {
        this.setPeriod(arg0, null);
    }

    public MutablePeriod(ReadableDuration arg0, ReadableInstant arg1) {
        super(arg0, arg1, null);
    }

    public MutablePeriod(Object arg0, PeriodType arg1) {
        super(arg0, arg1, null);
    }

    public MutablePeriod(ReadableInstant arg0, ReadableInstant arg1) {
        super(arg0, arg1, null);
    }

    public static MutablePeriod parse(String arg0, PeriodFormatter arg1) {
        return arg1.parsePeriod(arg0).toMutablePeriod();
    }

    public void setMonths(int arg0) {
        super.setField(DurationFieldType.months(), arg0);
    }

    @FromString
    public static MutablePeriod parse(String arg0) {
        return MutablePeriod.parse(arg0, ISOPeriodFormat.standard());
    }

    public MutablePeriod() {
        super(0L, (PeriodType)null, (Chronology)null);
    }

    public MutablePeriod(long arg0, PeriodType arg1) {
        super(arg0, arg1, (Chronology)null);
    }

    public MutablePeriod(long arg0) {
        super(arg0);
    }

    public MutablePeriod(Object arg0) {
        super(arg0, null, null);
    }

    public void clear() {
        super.setValues(new int[this.size()]);
    }

    public void addWeeks(int arg0) {
        super.addField(DurationFieldType.weeks(), arg0);
    }

    public void addMillis(int arg0) {
        super.addField(DurationFieldType.millis(), arg0);
    }

    public void addYears(int arg0) {
        super.addField(DurationFieldType.years(), arg0);
    }

    public void set(DurationFieldType arg0, int arg1) {
        super.setField(arg0, arg1);
    }

    public MutablePeriod(long arg0, long arg1, PeriodType arg2, Chronology arg3) {
        super(arg0, arg1, arg2, arg3);
    }

    public int getMinutes() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MINUTE_INDEX);
    }

    public void add(ReadableDuration arg0) {
        if (arg0 != null) {
            this.add(new Period(arg0.getMillis(), this.getPeriodType()));
        }
    }

    public void addDays(int arg0) {
        super.addField(DurationFieldType.days(), arg0);
    }

    public MutablePeriod(long arg0, long arg1) {
        super(arg0, arg1, null, null);
    }

    public void setPeriod(long arg0, Chronology arg1) {
        arg1 = DateTimeUtils.getChronology(arg1);
        this.setValues(arg1.get(this, arg0));
    }

    public void add(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7) {
        this.setPeriod(FieldUtils.safeAdd(this.getYears(), arg0), FieldUtils.safeAdd(this.getMonths(), arg1), FieldUtils.safeAdd(this.getWeeks(), arg2), FieldUtils.safeAdd(this.getDays(), arg3), FieldUtils.safeAdd(this.getHours(), arg4), FieldUtils.safeAdd(this.getMinutes(), arg5), FieldUtils.safeAdd(this.getSeconds(), arg6), FieldUtils.safeAdd(this.getMillis(), arg7));
    }

    public MutablePeriod(int arg0, int arg1, int arg2, int arg3) {
        super(0, 0, 0, 0, arg0, arg1, arg2, arg3, PeriodType.standard());
    }

    public MutablePeriod(long arg0, long arg1, PeriodType arg2) {
        super(arg0, arg1, arg2, null);
    }

    public void setPeriod(long arg0, long arg1) {
        this.setPeriod(arg0, arg1, null);
    }

    public MutablePeriod(ReadableDuration arg0, ReadableInstant arg1, PeriodType arg2) {
        super(arg0, arg1, arg2);
    }

    public void setMillis(int arg0) {
        super.setField(DurationFieldType.millis(), arg0);
    }

    public void setSeconds(int arg0) {
        super.setField(DurationFieldType.seconds(), arg0);
    }

    public MutablePeriod(long arg0, long arg1, Chronology arg2) {
        super(arg0, arg1, null, arg2);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone error");
        }
    }

    public void setPeriod(ReadablePeriod arg0) {
        super.setPeriod(arg0);
    }

    public MutablePeriod(Object arg0, PeriodType arg1, Chronology arg2) {
        super(arg0, arg1, arg2);
    }

    public void addMinutes(int arg0) {
        super.addField(DurationFieldType.minutes(), arg0);
    }

    public void setValue(int arg0, int arg1) {
        super.setValue(arg0, arg1);
    }

    public int getYears() {
        return this.getPeriodType().getIndexedField(this, PeriodType.YEAR_INDEX);
    }

    public void setPeriod(long arg0, long arg1, Chronology arg2) {
        arg2 = DateTimeUtils.getChronology(arg2);
        this.setValues(arg2.get(this, arg0, arg1));
    }

    public int getHours() {
        return this.getPeriodType().getIndexedField(this, PeriodType.HOUR_INDEX);
    }

    public MutablePeriod(long arg0, PeriodType arg1, Chronology arg2) {
        super(arg0, arg1, arg2);
    }

    public MutablePeriod(ReadableInstant arg0, ReadableDuration arg1, PeriodType arg2) {
        super(arg0, arg1, arg2);
    }

    public void addSeconds(int arg0) {
        super.addField(DurationFieldType.seconds(), arg0);
    }

    public MutablePeriod(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, PeriodType arg8) {
        super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
}

