/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.ReadWritableInterval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseInterval;
import org.joda.time.field.FieldUtils;

public class MutableInterval
extends BaseInterval
implements ReadWritableInterval,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5982824024992428470L;

    public MutableInterval(long arg0, long arg1) {
        super(arg0, arg1, null);
    }

    public void setDurationBeforeEnd(ReadableDuration arg0) {
        long l2 = DateTimeUtils.getDurationMillis(arg0);
        this.setStartMillis(FieldUtils.safeAdd(this.getEndMillis(), -l2));
    }

    public void setInterval(ReadableInterval arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Interval must not be null");
        }
        long l2 = arg0.getStartMillis();
        long l3 = arg0.getEndMillis();
        Chronology chronology = arg0.getChronology();
        super.setInterval(l2, l3, chronology);
    }

    public void setPeriodBeforeEnd(ReadablePeriod arg0) {
        if (arg0 == null) {
            this.setStartMillis(this.getEndMillis());
        } else {
            this.setStartMillis(this.getChronology().add(arg0, this.getEndMillis(), -1));
        }
    }

    public void setDurationAfterStart(long arg0) {
        this.setEndMillis(FieldUtils.safeAdd(this.getStartMillis(), arg0));
    }

    public MutableInterval(Object arg0) {
        super(arg0, null);
    }

    public void setInterval(long arg0, long arg1) {
        super.setInterval(arg0, arg1, this.getChronology());
    }

    public void setStartMillis(long arg0) {
        super.setInterval(arg0, this.getEndMillis(), this.getChronology());
    }

    public void setInterval(ReadableInstant arg0, ReadableInstant arg1) {
        if (arg0 == null && arg1 == null) {
            long l2 = DateTimeUtils.currentTimeMillis();
            this.setInterval(l2, l2);
        } else {
            long l3 = DateTimeUtils.getInstantMillis(arg0);
            long l4 = DateTimeUtils.getInstantMillis(arg1);
            Chronology chronology = DateTimeUtils.getInstantChronology(arg0);
            super.setInterval(l3, l4, chronology);
        }
    }

    public MutableInterval() {
        super(0L, 0L, null);
    }

    public MutableInterval(Object arg0, Chronology arg1) {
        super(arg0, arg1);
    }

    public void setEndMillis(long arg0) {
        super.setInterval(this.getStartMillis(), arg0, this.getChronology());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone error");
        }
    }

    public MutableInterval(long arg0, long arg1, Chronology arg2) {
        super(arg0, arg1, arg2);
    }

    public void setEnd(ReadableInstant arg0) {
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        super.setInterval(this.getStartMillis(), l2, this.getChronology());
    }

    public void setStart(ReadableInstant arg0) {
        long l2 = DateTimeUtils.getInstantMillis(arg0);
        super.setInterval(l2, this.getEndMillis(), this.getChronology());
    }

    public void setPeriodAfterStart(ReadablePeriod arg0) {
        if (arg0 == null) {
            this.setEndMillis(this.getStartMillis());
        } else {
            this.setEndMillis(this.getChronology().add(arg0, this.getStartMillis(), 1));
        }
    }

    public MutableInterval(ReadableDuration arg0, ReadableInstant arg1) {
        super(arg0, arg1);
    }

    public MutableInterval(ReadableInstant arg0, ReadableInstant arg1) {
        super(arg0, arg1);
    }

    public void setDurationAfterStart(ReadableDuration arg0) {
        long l2 = DateTimeUtils.getDurationMillis(arg0);
        this.setEndMillis(FieldUtils.safeAdd(this.getStartMillis(), l2));
    }

    public MutableInterval(ReadablePeriod arg0, ReadableInstant arg1) {
        super(arg0, arg1);
    }

    public void setChronology(Chronology arg0) {
        super.setInterval(this.getStartMillis(), this.getEndMillis(), arg0);
    }

    public MutableInterval copy() {
        return (MutableInterval)this.clone();
    }

    public MutableInterval(ReadableInstant arg0, ReadableDuration arg1) {
        super(arg0, arg1);
    }

    public static MutableInterval parse(String arg0) {
        return new MutableInterval(arg0);
    }

    public void setDurationBeforeEnd(long arg0) {
        this.setStartMillis(FieldUtils.safeAdd(this.getEndMillis(), -arg0));
    }

    public MutableInterval(ReadableInstant arg0, ReadablePeriod arg1) {
        super(arg0, arg1);
    }
}

