/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Months
extends BaseSingleFieldPeriod {
    public static final Months TEN;
    public static final Months THREE;
    public static final Months FIVE;
    public static final Months TWO;
    public static final Months ONE;
    public static final Months SEVEN;
    public static final Months TWELVE;
    public static final Months MAX_VALUE;
    public static final Months SIX;
    public static final Months EIGHT;
    public static final Months ELEVEN;
    public static final Months ZERO;
    public static final Months FOUR;
    private static final long serialVersionUID = 87525275727380867L;
    public static final Months MIN_VALUE;
    public static final Months NINE;
    private static final PeriodFormatter PARSER;

    public boolean isGreaterThan(Months arg0) {
        if (arg0 == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > arg0.getValue();
    }

    public Months negated() {
        return Months.months(FieldUtils.safeNegate(this.getValue()));
    }

    public static Months months(int arg0) {
        switch (arg0) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
            case 6: {
                return SIX;
            }
            case 7: {
                return SEVEN;
            }
            case 8: {
                return EIGHT;
            }
            case 9: {
                return NINE;
            }
            case 10: {
                return TEN;
            }
            case 11: {
                return ELEVEN;
            }
            case 12: {
                return TWELVE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Months(arg0);
    }

    @FromString
    public static Months parseMonths(String arg0) {
        if (arg0 == null) {
            return ZERO;
        }
        Period period = PARSER.parsePeriod(arg0);
        return Months.months(period.getMonths());
    }

    @ToString
    public String toString() {
        return "P" + String.valueOf(this.getValue()) + "M";
    }

    public static Months monthsBetween(ReadablePartial arg0, ReadablePartial arg1) {
        if (arg0 instanceof LocalDate && arg1 instanceof LocalDate) {
            Chronology chronology = DateTimeUtils.getChronology(arg0.getChronology());
            int n = chronology.months().getDifference(((LocalDate)arg1).getLocalMillis(), ((LocalDate)arg0).getLocalMillis());
            return Months.months(n);
        }
        int n = BaseSingleFieldPeriod.between(arg0, arg1, ZERO);
        return Months.months(n);
    }

    public Months plus(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        return Months.months(FieldUtils.safeAdd(this.getValue(), arg0));
    }

    private Months(int a2) {
        super(a2);
        Months a3;
    }

    public DurationFieldType getFieldType() {
        return DurationFieldType.months();
    }

    public PeriodType getPeriodType() {
        return PeriodType.months();
    }

    public Months multipliedBy(int arg0) {
        return Months.months(FieldUtils.safeMultiply(this.getValue(), arg0));
    }

    public static Months monthsIn(ReadableInterval arg0) {
        if (arg0 == null) {
            return ZERO;
        }
        int n = BaseSingleFieldPeriod.between(arg0.getStart(), arg0.getEnd(), DurationFieldType.months());
        return Months.months(n);
    }

    public int getMonths() {
        return this.getValue();
    }

    private Object readResolve() {
        Months a2;
        return Months.months(a2.getValue());
    }

    public Months plus(Months arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.plus(arg0.getValue());
    }

    static {
        ZERO = new Months(0);
        ONE = new Months(1);
        TWO = new Months(2);
        THREE = new Months(3);
        FOUR = new Months(4);
        FIVE = new Months(5);
        SIX = new Months(6);
        SEVEN = new Months(7);
        EIGHT = new Months(8);
        NINE = new Months(9);
        TEN = new Months(10);
        ELEVEN = new Months(11);
        TWELVE = new Months(12);
        MAX_VALUE = new Months(Integer.MAX_VALUE);
        MIN_VALUE = new Months(Integer.MIN_VALUE);
        PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.months());
    }

    public Months minus(Months arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.minus(arg0.getValue());
    }

    public static Months monthsBetween(ReadableInstant arg0, ReadableInstant arg1) {
        int n = BaseSingleFieldPeriod.between(arg0, arg1, DurationFieldType.months());
        return Months.months(n);
    }

    public boolean isLessThan(Months arg0) {
        if (arg0 == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < arg0.getValue();
    }

    public Months dividedBy(int arg0) {
        if (arg0 == 1) {
            return this;
        }
        return Months.months(this.getValue() / arg0);
    }

    public Months minus(int arg0) {
        return this.plus(FieldUtils.safeNegate(arg0));
    }
}

