/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BasePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public final class MonthDay
extends BasePartial
implements ReadablePartial,
Serializable {
    public static final int DAY_OF_MONTH = 1;
    private static final DateTimeFormatter PARSER;
    private static final long serialVersionUID = 2954560699050434609L;
    private static final DateTimeFieldType[] FIELD_TYPES;
    public static final int MONTH_OF_YEAR = 0;

    public int getMonthOfYear() {
        return this.getValue(0);
    }

    public MonthDay withField(DateTimeFieldType arg0, int arg1) {
        int n = this.indexOfSupported(arg0);
        if (arg1 == this.getValue(n)) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n).set(this, n, nArray, arg1);
        return new MonthDay(this, nArray);
    }

    static {
        FIELD_TYPES = new DateTimeFieldType[]{DateTimeFieldType.monthOfYear(), DateTimeFieldType.dayOfMonth()};
        PARSER = new DateTimeFormatterBuilder().appendOptional(ISODateTimeFormat.localDateParser().getParser()).appendOptional(DateTimeFormat.forPattern("--MM-dd").getParser()).toFormatter();
    }

    protected DateTimeField getField(int arg0, Chronology arg1) {
        switch (arg0) {
            case 0: {
                return arg1.monthOfYear();
            }
            case 1: {
                return arg1.dayOfMonth();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + arg0);
    }

    public MonthDay withDayOfMonth(int arg0) {
        int[] nArray = this.getValues();
        nArray = this.getChronology().dayOfMonth().set(this, 1, nArray, arg0);
        return new MonthDay(this, nArray);
    }

    public MonthDay(int arg0, int arg1) {
        this(arg0, arg1, null);
    }

    private Object readResolve() {
        MonthDay a2;
        if (!DateTimeZone.UTC.equals(a2.getChronology().getZone())) {
            return new MonthDay(a2, a2.getChronology().withUTC());
        }
        return a2;
    }

    public MonthDay() {
    }

    public Property dayOfMonth() {
        return new Property(this, 1);
    }

    @FromString
    public static MonthDay parse(String arg0) {
        return MonthDay.parse(arg0, PARSER);
    }

    public static MonthDay now(Chronology arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new MonthDay(arg0);
    }

    public MonthDay plusMonths(int arg0) {
        return this.withFieldAdded(DurationFieldType.months(), arg0);
    }

    public static MonthDay fromDateFields(Date arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new MonthDay(arg0.getMonth() + 1, arg0.getDate());
    }

    public MonthDay plusDays(int arg0) {
        return this.withFieldAdded(DurationFieldType.days(), arg0);
    }

    public MonthDay(Object arg0) {
        super(arg0, null, ISODateTimeFormat.localDateParser());
    }

    public DateTimeFieldType getFieldType(int arg0) {
        return FIELD_TYPES[arg0];
    }

    public String toString(String arg0, Locale arg1) throws IllegalArgumentException {
        if (arg0 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(arg0).withLocale(arg1).print(this);
    }

    public static MonthDay now(DateTimeZone arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new MonthDay(arg0);
    }

    public MonthDay(Object arg0, Chronology arg1) {
        super(arg0, DateTimeUtils.getChronology(arg1), ISODateTimeFormat.localDateParser());
    }

    public MonthDay plus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, 1);
    }

    @ToString
    public String toString() {
        ArrayList<DateTimeFieldType> arrayList = new ArrayList<DateTimeFieldType>();
        arrayList.add(DateTimeFieldType.monthOfYear());
        arrayList.add(DateTimeFieldType.dayOfMonth());
        return ISODateTimeFormat.forFields(arrayList, true, true).print(this);
    }

    public String toString(String arg0) {
        if (arg0 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(arg0).print(this);
    }

    public MonthDay withPeriodAdded(ReadablePeriod arg0, int arg1) {
        if (arg0 == null || arg1 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        for (int i2 = 0; i2 < arg0.size(); ++i2) {
            DurationFieldType durationFieldType = arg0.getFieldType(i2);
            int n = this.indexOf(durationFieldType);
            if (n < 0) continue;
            nArray = this.getField(n).add(this, n, nArray, FieldUtils.safeMultiply(arg0.getValue(i2), arg1));
        }
        return new MonthDay(this, nArray);
    }

    public static MonthDay fromCalendarFields(Calendar arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new MonthDay(arg0.get(2) + 1, arg0.get(5));
    }

    public MonthDay(long arg0) {
        super(arg0);
    }

    public MonthDay withMonthOfYear(int arg0) {
        int[] nArray = this.getValues();
        nArray = this.getChronology().monthOfYear().set(this, 0, nArray, arg0);
        return new MonthDay(this, nArray);
    }

    public MonthDay withChronologyRetainFields(Chronology arg0) {
        arg0 = DateTimeUtils.getChronology(arg0);
        if ((arg0 = arg0.withUTC()) == this.getChronology()) {
            return this;
        }
        MonthDay monthDay = new MonthDay(this, arg0);
        arg0.validate(monthDay, this.getValues());
        return monthDay;
    }

    MonthDay(MonthDay a2, Chronology a3) {
        super((BasePartial)a2, a3);
        MonthDay a4;
    }

    public int size() {
        return 2;
    }

    public Property property(DateTimeFieldType arg0) {
        return new Property(this, this.indexOfSupported(arg0));
    }

    public MonthDay minus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, -1);
    }

    public LocalDate toLocalDate(int arg0) {
        return new LocalDate(arg0, this.getMonthOfYear(), this.getDayOfMonth(), this.getChronology());
    }

    public MonthDay minusDays(int arg0) {
        return this.withFieldAdded(DurationFieldType.days(), FieldUtils.safeNegate(arg0));
    }

    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public MonthDay withFieldAdded(DurationFieldType arg0, int arg1) {
        int n = this.indexOfSupported(arg0);
        if (arg1 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        nArray = this.getField(n).add(this, n, nArray, arg1);
        return new MonthDay(this, nArray);
    }

    public MonthDay(DateTimeZone arg0) {
        super(ISOChronology.getInstance(arg0));
    }

    public int getDayOfMonth() {
        return this.getValue(1);
    }

    public MonthDay(long arg0, Chronology arg1) {
        super(arg0, arg1);
    }

    public static MonthDay now() {
        return new MonthDay();
    }

    public Property monthOfYear() {
        return new Property(this, 0);
    }

    public static MonthDay parse(String arg0, DateTimeFormatter arg1) {
        LocalDate localDate = arg1.parseLocalDate(arg0);
        return new MonthDay(localDate.getMonthOfYear(), localDate.getDayOfMonth());
    }

    MonthDay(MonthDay a2, int[] a3) {
        super((BasePartial)a2, a3);
        MonthDay a4;
    }

    public MonthDay minusMonths(int arg0) {
        return this.withFieldAdded(DurationFieldType.months(), FieldUtils.safeNegate(arg0));
    }

    public MonthDay(int arg0, int arg1, Chronology arg2) {
        super(new int[]{arg0, arg1}, arg2);
    }

    public MonthDay(Chronology arg0) {
        super(arg0);
    }

    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private final int iFieldIndex;
        private final MonthDay iBase;
        private static final long serialVersionUID = 5727734012190224363L;

        public int get() {
            return this.iBase.getValue(this.iFieldIndex);
        }

        public MonthDay setCopy(String arg0) {
            return this.setCopy(arg0, null);
        }

        public MonthDay addToCopy(int arg0) {
            int[] nArray = this.iBase.getValues();
            nArray = this.getField().add(this.iBase, this.iFieldIndex, nArray, arg0);
            return new MonthDay(this.iBase, nArray);
        }

        public DateTimeField getField() {
            return this.iBase.getField(this.iFieldIndex);
        }

        public MonthDay addWrapFieldToCopy(int arg0) {
            int[] nArray = this.iBase.getValues();
            nArray = this.getField().addWrapField(this.iBase, this.iFieldIndex, nArray, arg0);
            return new MonthDay(this.iBase, nArray);
        }

        public MonthDay getMonthDay() {
            return this.iBase;
        }

        protected ReadablePartial getReadablePartial() {
            return this.iBase;
        }

        public MonthDay setCopy(int arg0) {
            int[] nArray = this.iBase.getValues();
            nArray = this.getField().set(this.iBase, this.iFieldIndex, nArray, arg0);
            return new MonthDay(this.iBase, nArray);
        }

        Property(MonthDay a2, int a3) {
            Property a4;
            a4.iBase = a2;
            a4.iFieldIndex = a3;
        }

        public MonthDay setCopy(String arg0, Locale arg1) {
            int[] nArray = this.iBase.getValues();
            nArray = this.getField().set(this.iBase, this.iFieldIndex, nArray, arg0, arg1);
            return new MonthDay(this.iBase, nArray);
        }
    }
}

