/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseLocal;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.PartialConverter;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class LocalDateTime
extends BaseLocal
implements ReadablePartial,
Serializable {
    private final long iLocalMillis;
    private static final int MILLIS_OF_DAY = 3;
    private static final int DAY_OF_MONTH = 2;
    private final Chronology iChronology;
    private static final long serialVersionUID = -268716875315837168L;
    private static final int YEAR = 0;
    private static final int MONTH_OF_YEAR = 1;

    public LocalDateTime withHourOfDay(int arg0) {
        return this.withLocalMillis(this.getChronology().hourOfDay().set(this.getLocalMillis(), arg0));
    }

    private Date correctDstTransition(Date a2, TimeZone a3) {
        LocalDateTime a4;
        Calendar calendar = Calendar.getInstance(a3);
        calendar.setTime(a2);
        LocalDateTime localDateTime = LocalDateTime.fromCalendarFields(calendar);
        if (localDateTime.isBefore(a4)) {
            while (localDateTime.isBefore(a4)) {
                calendar.setTimeInMillis(calendar.getTimeInMillis() + 60000L);
                localDateTime = LocalDateTime.fromCalendarFields(calendar);
            }
            while (!localDateTime.isBefore(a4)) {
                calendar.setTimeInMillis(calendar.getTimeInMillis() - 1000L);
                localDateTime = LocalDateTime.fromCalendarFields(calendar);
            }
            calendar.setTimeInMillis(calendar.getTimeInMillis() + 1000L);
        } else if (localDateTime.equals(a4)) {
            Calendar calendar2 = Calendar.getInstance(a3);
            calendar2.setTimeInMillis(calendar.getTimeInMillis() - (long)a3.getDSTSavings());
            localDateTime = LocalDateTime.fromCalendarFields(calendar2);
            if (localDateTime.equals(a4)) {
                calendar = calendar2;
            }
        }
        return calendar.getTime();
    }

    public LocalDateTime withSecondOfMinute(int arg0) {
        return this.withLocalMillis(this.getChronology().secondOfMinute().set(this.getLocalMillis(), arg0));
    }

    public Property millisOfDay() {
        return new Property(this, this.getChronology().millisOfDay());
    }

    public static LocalDateTime now(Chronology arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new LocalDateTime(arg0);
    }

    public static LocalDateTime parse(String arg0, DateTimeFormatter arg1) {
        return arg1.parseLocalDateTime(arg0);
    }

    public LocalDateTime withTime(int arg0, int arg1, int arg2, int arg3) {
        Chronology chronology = this.getChronology();
        long l2 = this.getLocalMillis();
        l2 = chronology.hourOfDay().set(l2, arg0);
        l2 = chronology.minuteOfHour().set(l2, arg1);
        l2 = chronology.secondOfMinute().set(l2, arg2);
        l2 = chronology.millisOfSecond().set(l2, arg3);
        return this.withLocalMillis(l2);
    }

    public LocalDateTime plusMonths(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().months().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public LocalDateTime withYear(int arg0) {
        return this.withLocalMillis(this.getChronology().year().set(this.getLocalMillis(), arg0));
    }

    public LocalDateTime plus(ReadableDuration arg0) {
        return this.withDurationAdded(arg0, 1);
    }

    public LocalDateTime(long arg0) {
        this(arg0, (Chronology)ISOChronology.getInstance());
    }

    public LocalDateTime withWeekyear(int arg0) {
        return this.withLocalMillis(this.getChronology().weekyear().set(this.getLocalMillis(), arg0));
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)arg0;
            if (this.iChronology.equals(localDateTime.iChronology)) {
                return this.iLocalMillis == localDateTime.iLocalMillis;
            }
        }
        return super.equals(arg0);
    }

    public LocalDateTime(Object arg0) {
        this(arg0, (Chronology)null);
    }

    public int getValue(int arg0) {
        switch (arg0) {
            case 0: {
                return this.getChronology().year().get(this.getLocalMillis());
            }
            case 1: {
                return this.getChronology().monthOfYear().get(this.getLocalMillis());
            }
            case 2: {
                return this.getChronology().dayOfMonth().get(this.getLocalMillis());
            }
            case 3: {
                return this.getChronology().millisOfDay().get(this.getLocalMillis());
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + arg0);
    }

    public int getMillisOfSecond() {
        return this.getChronology().millisOfSecond().get(this.getLocalMillis());
    }

    public LocalDateTime plusMinutes(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().minutes().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public Property property(DateTimeFieldType arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(arg0)) {
            throw new IllegalArgumentException("Field '" + arg0 + "' is not supported");
        }
        return new Property(this, arg0.getField(this.getChronology()));
    }

    public int getDayOfWeek() {
        return this.getChronology().dayOfWeek().get(this.getLocalMillis());
    }

    public Property yearOfCentury() {
        return new Property(this, this.getChronology().yearOfCentury());
    }

    public DateTime toDateTime(DateTimeZone arg0) {
        arg0 = DateTimeUtils.getZone(arg0);
        Chronology chronology = this.iChronology.withZone(arg0);
        return new DateTime(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), this.getHourOfDay(), this.getMinuteOfHour(), this.getSecondOfMinute(), this.getMillisOfSecond(), chronology);
    }

    public int getWeekOfWeekyear() {
        return this.getChronology().weekOfWeekyear().get(this.getLocalMillis());
    }

    public LocalDateTime minusWeeks(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().weeks().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public int getSecondOfMinute() {
        return this.getChronology().secondOfMinute().get(this.getLocalMillis());
    }

    public LocalDateTime(Object arg0, DateTimeZone arg1) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(arg0);
        Chronology chronology = partialConverter.getChronology(arg0, arg1);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        int[] nArray = partialConverter.getPartialValues(this, arg0, chronology, ISODateTimeFormat.localDateOptionalTimeParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public LocalDate toLocalDate() {
        return new LocalDate(this.getLocalMillis(), this.getChronology());
    }

    public int getDayOfYear() {
        return this.getChronology().dayOfYear().get(this.getLocalMillis());
    }

    public LocalDateTime withDayOfMonth(int arg0) {
        return this.withLocalMillis(this.getChronology().dayOfMonth().set(this.getLocalMillis(), arg0));
    }

    public Property hourOfDay() {
        return new Property(this, this.getChronology().hourOfDay());
    }

    protected long getLocalMillis() {
        return this.iLocalMillis;
    }

    public LocalDateTime plusWeeks(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().weeks().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public LocalDateTime minusDays(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().days().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public Property dayOfWeek() {
        return new Property(this, this.getChronology().dayOfWeek());
    }

    public LocalDateTime withMonthOfYear(int arg0) {
        return this.withLocalMillis(this.getChronology().monthOfYear().set(this.getLocalMillis(), arg0));
    }

    public Property weekyear() {
        return new Property(this, this.getChronology().weekyear());
    }

    public Property centuryOfEra() {
        return new Property(this, this.getChronology().centuryOfEra());
    }

    public LocalDateTime plusDays(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().days().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public LocalDateTime withMinuteOfHour(int arg0) {
        return this.withLocalMillis(this.getChronology().minuteOfHour().set(this.getLocalMillis(), arg0));
    }

    public LocalDateTime plusSeconds(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().seconds().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public Date toDate(TimeZone arg0) {
        Calendar calendar = Calendar.getInstance(arg0);
        calendar.clear();
        calendar.set(this.getYear(), this.getMonthOfYear() - 1, this.getDayOfMonth(), this.getHourOfDay(), this.getMinuteOfHour(), this.getSecondOfMinute());
        Date date = calendar.getTime();
        date.setTime(date.getTime() + (long)this.getMillisOfSecond());
        return this.correctDstTransition(date, arg0);
    }

    public LocalDateTime plusMillis(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().millis().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public String toString(String arg0) {
        if (arg0 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(arg0).print(this);
    }

    public LocalDateTime withDurationAdded(ReadableDuration arg0, int arg1) {
        if (arg0 == null || arg1 == 0) {
            return this;
        }
        long l2 = this.getChronology().add(this.getLocalMillis(), arg0.getMillis(), arg1);
        return this.withLocalMillis(l2);
    }

    public LocalDateTime withFields(ReadablePartial arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().set(arg0, this.getLocalMillis()));
    }

    public String toString(String arg0, Locale arg1) throws IllegalArgumentException {
        if (arg0 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(arg0).withLocale(arg1).print(this);
    }

    public LocalDateTime plus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, 1);
    }

    public Property secondOfMinute() {
        return new Property(this, this.getChronology().secondOfMinute());
    }

    public LocalDateTime withFieldAdded(DurationFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (arg1 == 0) {
            return this;
        }
        long l2 = arg0.getField(this.getChronology()).add(this.getLocalMillis(), arg1);
        return this.withLocalMillis(l2);
    }

    public int getWeekyear() {
        return this.getChronology().weekyear().get(this.getLocalMillis());
    }

    public Property minuteOfHour() {
        return new Property(this, this.getChronology().minuteOfHour());
    }

    public Property weekOfWeekyear() {
        return new Property(this, this.getChronology().weekOfWeekyear());
    }

    public Property era() {
        return new Property(this, this.getChronology().era());
    }

    private Object readResolve() {
        LocalDateTime a2;
        if (a2.iChronology == null) {
            return new LocalDateTime(a2.iLocalMillis, (Chronology)ISOChronology.getInstanceUTC());
        }
        if (!DateTimeZone.UTC.equals(a2.iChronology.getZone())) {
            return new LocalDateTime(a2.iLocalMillis, a2.iChronology.withUTC());
        }
        return a2;
    }

    protected DateTimeField getField(int arg0, Chronology arg1) {
        switch (arg0) {
            case 0: {
                return arg1.year();
            }
            case 1: {
                return arg1.monthOfYear();
            }
            case 2: {
                return arg1.dayOfMonth();
            }
            case 3: {
                return arg1.millisOfDay();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + arg0);
    }

    public Property millisOfSecond() {
        return new Property(this, this.getChronology().millisOfSecond());
    }

    public LocalDateTime withDayOfWeek(int arg0) {
        return this.withLocalMillis(this.getChronology().dayOfWeek().set(this.getLocalMillis(), arg0));
    }

    public LocalDateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, Chronology arg7) {
        arg7 = DateTimeUtils.getChronology(arg7).withUTC();
        long l2 = arg7.getDateTimeMillis(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        this.iChronology = arg7;
        this.iLocalMillis = l2;
    }

    public LocalDateTime minusSeconds(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().seconds().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public LocalDateTime minusMillis(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().millis().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public LocalDateTime withYearOfCentury(int arg0) {
        return this.withLocalMillis(this.getChronology().yearOfCentury().set(this.getLocalMillis(), arg0));
    }

    public LocalDateTime withWeekOfWeekyear(int arg0) {
        return this.withLocalMillis(this.getChronology().weekOfWeekyear().set(this.getLocalMillis(), arg0));
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    public int getYearOfEra() {
        return this.getChronology().yearOfEra().get(this.getLocalMillis());
    }

    public LocalDateTime withMillisOfSecond(int arg0) {
        return this.withLocalMillis(this.getChronology().millisOfSecond().set(this.getLocalMillis(), arg0));
    }

    public int getCenturyOfEra() {
        return this.getChronology().centuryOfEra().get(this.getLocalMillis());
    }

    public LocalDateTime withDate(int arg0, int arg1, int arg2) {
        Chronology chronology = this.getChronology();
        long l2 = this.getLocalMillis();
        l2 = chronology.year().set(l2, arg0);
        l2 = chronology.monthOfYear().set(l2, arg1);
        l2 = chronology.dayOfMonth().set(l2, arg2);
        return this.withLocalMillis(l2);
    }

    public LocalDateTime withDayOfYear(int arg0) {
        return this.withLocalMillis(this.getChronology().dayOfYear().set(this.getLocalMillis(), arg0));
    }

    public LocalDateTime(Chronology arg0) {
        this(DateTimeUtils.currentTimeMillis(), arg0);
    }

    public Property dayOfYear() {
        return new Property(this, this.getChronology().dayOfYear());
    }

    public static LocalDateTime fromDateFields(Date arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (arg0.getTime() < 0L) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(arg0);
            return LocalDateTime.fromCalendarFields(gregorianCalendar);
        }
        return new LocalDateTime(arg0.getYear() + 1900, arg0.getMonth() + 1, arg0.getDate(), arg0.getHours(), arg0.getMinutes(), arg0.getSeconds(), ((int)(arg0.getTime() % 1000L) + 1000) % 1000);
    }

    public int getDayOfMonth() {
        return this.getChronology().dayOfMonth().get(this.getLocalMillis());
    }

    public LocalDateTime withMillisOfDay(int arg0) {
        return this.withLocalMillis(this.getChronology().millisOfDay().set(this.getLocalMillis(), arg0));
    }

    public LocalDateTime withField(DateTimeFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        long l2 = arg0.getField(this.getChronology()).set(this.getLocalMillis(), arg1);
        return this.withLocalMillis(l2);
    }

    public Property monthOfYear() {
        return new Property(this, this.getChronology().monthOfYear());
    }

    public LocalDateTime withYearOfEra(int arg0) {
        return this.withLocalMillis(this.getChronology().yearOfEra().set(this.getLocalMillis(), arg0));
    }

    public Property dayOfMonth() {
        return new Property(this, this.getChronology().dayOfMonth());
    }

    public Property yearOfEra() {
        return new Property(this, this.getChronology().yearOfEra());
    }

    public LocalDateTime(long arg0, DateTimeZone arg1) {
        this(arg0, (Chronology)ISOChronology.getInstance(arg1));
    }

    public LocalDateTime minusMonths(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().months().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    @ToString
    public String toString() {
        return ISODateTimeFormat.dateTime().print(this);
    }

    public LocalDateTime minusMinutes(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().minutes().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public LocalDateTime withCenturyOfEra(int arg0) {
        return this.withLocalMillis(this.getChronology().centuryOfEra().set(this.getLocalMillis(), arg0));
    }

    public int getMinuteOfHour() {
        return this.getChronology().minuteOfHour().get(this.getLocalMillis());
    }

    public Property year() {
        return new Property(this, this.getChronology().year());
    }

    public int getYearOfCentury() {
        return this.getChronology().yearOfCentury().get(this.getLocalMillis());
    }

    public int getHourOfDay() {
        return this.getChronology().hourOfDay().get(this.getLocalMillis());
    }

    public int get(DateTimeFieldType arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        return arg0.getField(this.getChronology()).get(this.getLocalMillis());
    }

    public LocalDateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {
        this(arg0, arg1, arg2, arg3, arg4, arg5, arg6, ISOChronology.getInstanceUTC());
    }

    public LocalDateTime(long arg0, Chronology arg1) {
        long l2;
        arg1 = DateTimeUtils.getChronology(arg1);
        this.iLocalMillis = l2 = arg1.getZone().getMillisKeepLocal(DateTimeZone.UTC, arg0);
        this.iChronology = arg1.withUTC();
    }

    public LocalDateTime minus(ReadableDuration arg0) {
        return this.withDurationAdded(arg0, -1);
    }

    public LocalDateTime(Object arg0, Chronology arg1) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(arg0);
        arg1 = partialConverter.getChronology(arg0, arg1);
        arg1 = DateTimeUtils.getChronology(arg1);
        this.iChronology = arg1.withUTC();
        int[] nArray = partialConverter.getPartialValues(this, arg0, arg1, ISODateTimeFormat.localDateOptionalTimeParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public LocalDateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        this(arg0, arg1, arg2, arg3, arg4, arg5, 0, ISOChronology.getInstanceUTC());
    }

    public int getEra() {
        return this.getChronology().era().get(this.getLocalMillis());
    }

    public boolean isSupported(DurationFieldType arg0) {
        if (arg0 == null) {
            return false;
        }
        return arg0.getField(this.getChronology()).isSupported();
    }

    LocalDateTime withLocalMillis(long a2) {
        LocalDateTime a3;
        return a2 == a3.getLocalMillis() ? a3 : new LocalDateTime(a2, a3.getChronology());
    }

    public LocalDateTime() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance());
    }

    public DateTime toDateTime() {
        return this.toDateTime((DateTimeZone)null);
    }

    public static LocalDateTime fromCalendarFields(Calendar arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        int n = arg0.get(0);
        int n2 = arg0.get(1);
        return new LocalDateTime(n == 1 ? n2 : 1 - n2, arg0.get(2) + 1, arg0.get(5), arg0.get(11), arg0.get(12), arg0.get(13), arg0.get(14));
    }

    public static LocalDateTime now() {
        return new LocalDateTime();
    }

    public LocalDateTime minusHours(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().hours().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    @FromString
    public static LocalDateTime parse(String arg0) {
        return LocalDateTime.parse(arg0, ISODateTimeFormat.localDateOptionalTimeParser());
    }

    public LocalDateTime minus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, -1);
    }

    public LocalDateTime withEra(int arg0) {
        return this.withLocalMillis(this.getChronology().era().set(this.getLocalMillis(), arg0));
    }

    public LocalTime toLocalTime() {
        return new LocalTime(this.getLocalMillis(), this.getChronology());
    }

    public int getMonthOfYear() {
        return this.getChronology().monthOfYear().get(this.getLocalMillis());
    }

    public LocalDateTime plusYears(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().years().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public boolean isSupported(DateTimeFieldType arg0) {
        if (arg0 == null) {
            return false;
        }
        return arg0.getField(this.getChronology()).isSupported();
    }

    public Date toDate() {
        int n = this.getDayOfMonth();
        Date date = new Date(this.getYear() - 1900, this.getMonthOfYear() - 1, n, this.getHourOfDay(), this.getMinuteOfHour(), this.getSecondOfMinute());
        date.setTime(date.getTime() + (long)this.getMillisOfSecond());
        return this.correctDstTransition(date, TimeZone.getDefault());
    }

    public LocalDateTime(DateTimeZone arg0) {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance(arg0));
    }

    public LocalDateTime withPeriodAdded(ReadablePeriod arg0, int arg1) {
        if (arg0 == null || arg1 == 0) {
            return this;
        }
        long l2 = this.getChronology().add(arg0, this.getLocalMillis(), arg1);
        return this.withLocalMillis(l2);
    }

    public int size() {
        return 4;
    }

    public LocalDateTime(int arg0, int arg1, int arg2, int arg3, int arg4) {
        this(arg0, arg1, arg2, arg3, arg4, 0, 0, ISOChronology.getInstanceUTC());
    }

    public int getMillisOfDay() {
        return this.getChronology().millisOfDay().get(this.getLocalMillis());
    }

    public int getYear() {
        return this.getChronology().year().get(this.getLocalMillis());
    }

    public LocalDateTime minusYears(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().years().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public static LocalDateTime now(DateTimeZone arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new LocalDateTime(arg0);
    }

    public LocalDateTime plusHours(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().hours().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public int compareTo(ReadablePartial arg0) {
        if (this == arg0) {
            return 0;
        }
        if (arg0 instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)arg0;
            if (this.iChronology.equals(localDateTime.iChronology)) {
                return this.iLocalMillis < localDateTime.iLocalMillis ? -1 : (this.iLocalMillis == localDateTime.iLocalMillis ? 0 : 1);
            }
        }
        return super.compareTo(arg0);
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private transient LocalDateTime iInstant;
        private static final long serialVersionUID = -358138762846288L;
        private transient DateTimeField iField;

        public LocalDateTime addToCopy(long arg0) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), arg0));
        }

        public LocalDateTime roundHalfFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfFloor(this.iInstant.getLocalMillis()));
        }

        public LocalDateTime getLocalDateTime() {
            return this.iInstant;
        }

        public LocalDateTime withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public LocalDateTime setCopy(String arg0, Locale arg1) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), arg0, arg1));
        }

        private void readObject(ObjectInputStream a2) throws IOException, ClassNotFoundException {
            Property a3;
            a3.iInstant = (LocalDateTime)a2.readObject();
            DateTimeFieldType dateTimeFieldType = (DateTimeFieldType)a2.readObject();
            a3.iField = dateTimeFieldType.getField(a3.iInstant.getChronology());
        }

        private void writeObject(ObjectOutputStream a2) throws IOException {
            Property a3;
            a2.writeObject(a3.iInstant);
            a2.writeObject(a3.iField.getType());
        }

        public LocalDateTime setCopy(String arg0) {
            return this.setCopy(arg0, null);
        }

        public LocalDateTime roundHalfEvenCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfEven(this.iInstant.getLocalMillis()));
        }

        public LocalDateTime addToCopy(int arg0) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), arg0));
        }

        protected Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public LocalDateTime addWrapFieldToCopy(int arg0) {
            return this.iInstant.withLocalMillis(this.iField.addWrapField(this.iInstant.getLocalMillis(), arg0));
        }

        public LocalDateTime withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }

        public DateTimeField getField() {
            return this.iField;
        }

        public LocalDateTime roundFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundFloor(this.iInstant.getLocalMillis()));
        }

        public LocalDateTime setCopy(int arg0) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), arg0));
        }

        Property(LocalDateTime a2, DateTimeField a3) {
            Property a4;
            a4.iInstant = a2;
            a4.iField = a3;
        }

        public LocalDateTime roundHalfCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfCeiling(this.iInstant.getLocalMillis()));
        }

        public LocalDateTime roundCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundCeiling(this.iInstant.getLocalMillis()));
        }

        protected long getMillis() {
            return this.iInstant.getLocalMillis();
        }
    }
}

