/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.convert.FromString;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.InstantConverter;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class Instant
extends AbstractInstant
implements ReadableInstant,
Serializable {
    private static final long serialVersionUID = 3299096530934209741L;
    private final long iMillis;

    public MutableDateTime toMutableDateTime() {
        return new MutableDateTime(this.getMillis(), (Chronology)ISOChronology.getInstance());
    }

    public Instant() {
        this.iMillis = DateTimeUtils.currentTimeMillis();
    }

    public Instant plus(long arg0) {
        return this.withDurationAdded(arg0, 1);
    }

    public Instant(Object arg0) {
        InstantConverter instantConverter = ConverterManager.getInstance().getInstantConverter(arg0);
        this.iMillis = instantConverter.getInstantMillis(arg0, ISOChronology.getInstanceUTC());
    }

    @Deprecated
    public DateTime toDateTimeISO() {
        return this.toDateTime();
    }

    public Instant(long arg0) {
        this.iMillis = arg0;
    }

    public long getMillis() {
        return this.iMillis;
    }

    public Instant minus(ReadableDuration arg0) {
        return this.withDurationAdded(arg0, -1);
    }

    public Instant withMillis(long arg0) {
        return arg0 == this.iMillis ? this : new Instant(arg0);
    }

    public Instant minus(long arg0) {
        return this.withDurationAdded(arg0, -1);
    }

    public Instant withDurationAdded(long arg0, int arg1) {
        if (arg0 == 0L || arg1 == 0) {
            return this;
        }
        long l2 = this.getChronology().add(this.getMillis(), arg0, arg1);
        return this.withMillis(l2);
    }

    @FromString
    public static Instant parse(String arg0) {
        return Instant.parse(arg0, ISODateTimeFormat.dateTimeParser());
    }

    public static Instant parse(String arg0, DateTimeFormatter arg1) {
        return arg1.parseDateTime(arg0).toInstant();
    }

    @Deprecated
    public MutableDateTime toMutableDateTimeISO() {
        return this.toMutableDateTime();
    }

    public Chronology getChronology() {
        return ISOChronology.getInstanceUTC();
    }

    public static Instant now() {
        return new Instant();
    }

    public Instant toInstant() {
        return this;
    }

    public Instant withDurationAdded(ReadableDuration arg0, int arg1) {
        if (arg0 == null || arg1 == 0) {
            return this;
        }
        return this.withDurationAdded(arg0.getMillis(), arg1);
    }

    public Instant plus(ReadableDuration arg0) {
        return this.withDurationAdded(arg0, 1);
    }

    public DateTime toDateTime() {
        return new DateTime(this.getMillis(), (Chronology)ISOChronology.getInstance());
    }
}

