/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.JodaTimePermission;
import org.joda.time.PeriodType;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.ISOChronology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeUtils {
    private static final AtomicReference<Map<String, DateTimeZone>> cZoneNames;
    private static final SystemMillisProvider SYSTEM_MILLIS_PROVIDER;
    private static volatile MillisProvider cMillisProvider;

    private static void checkPermission() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("CurrentTime.setProvider"));
        }
    }

    public static final void setCurrentMillisFixed(long arg0) throws SecurityException {
        DateTimeUtils.checkPermission();
        cMillisProvider = new FixedMillisProvider(arg0);
    }

    protected DateTimeUtils() {
    }

    public static final ReadableInterval getReadableInterval(ReadableInterval arg0) {
        if (arg0 == null) {
            long l2 = DateTimeUtils.currentTimeMillis();
            arg0 = new Interval(l2, l2);
        }
        return arg0;
    }

    public static final PeriodType getPeriodType(PeriodType arg0) {
        if (arg0 == null) {
            return PeriodType.standard();
        }
        return arg0;
    }

    public static final void setCurrentMillisOffset(long arg0) throws SecurityException {
        DateTimeUtils.checkPermission();
        cMillisProvider = arg0 == 0L ? SYSTEM_MILLIS_PROVIDER : new OffsetMillisProvider(arg0);
    }

    public static final long getInstantMillis(ReadableInstant arg0) {
        if (arg0 == null) {
            return DateTimeUtils.currentTimeMillis();
        }
        return arg0.getMillis();
    }

    public static final boolean isContiguous(ReadablePartial arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Partial must not be null");
        }
        DurationFieldType durationFieldType = null;
        for (int i2 = 0; i2 < arg0.size(); ++i2) {
            DateTimeField dateTimeField = arg0.getField(i2);
            if (i2 > 0 && (dateTimeField.getRangeDurationField() == null || dateTimeField.getRangeDurationField().getType() != durationFieldType)) {
                return false;
            }
            durationFieldType = dateTimeField.getDurationField().getType();
        }
        return true;
    }

    public static final Chronology getIntervalChronology(ReadableInterval arg0) {
        if (arg0 == null) {
            return ISOChronology.getInstance();
        }
        Chronology chronology = arg0.getChronology();
        if (chronology == null) {
            return ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final void setCurrentMillisProvider(MillisProvider arg0) throws SecurityException {
        if (arg0 == null) {
            throw new IllegalArgumentException("The MillisProvider must not be null");
        }
        DateTimeUtils.checkPermission();
        cMillisProvider = arg0;
    }

    public static final DateFormatSymbols getDateFormatSymbols(Locale arg0) {
        try {
            Method method = DateFormatSymbols.class.getMethod("getInstance", Locale.class);
            return (DateFormatSymbols)method.invoke(null, arg0);
        }
        catch (Exception exception) {
            return new DateFormatSymbols(arg0);
        }
    }

    public static final long getDurationMillis(ReadableDuration arg0) {
        if (arg0 == null) {
            return 0L;
        }
        return arg0.getMillis();
    }

    public static final long currentTimeMillis() {
        return cMillisProvider.getMillis();
    }

    public static final void setCurrentMillisSystem() throws SecurityException {
        DateTimeUtils.checkPermission();
        cMillisProvider = SYSTEM_MILLIS_PROVIDER;
    }

    public static final long fromJulianDay(double arg0) {
        double d2 = arg0 - 2440587.5;
        return (long)(d2 * 8.64E7);
    }

    public static final Chronology getChronology(Chronology arg0) {
        if (arg0 == null) {
            return ISOChronology.getInstance();
        }
        return arg0;
    }

    public static final DateTimeZone getZone(DateTimeZone arg0) {
        if (arg0 == null) {
            return DateTimeZone.getDefault();
        }
        return arg0;
    }

    private static Map<String, DateTimeZone> buildDefaultTimeZoneNames() {
        LinkedHashMap<String, DateTimeZone> linkedHashMap = new LinkedHashMap<String, DateTimeZone>();
        linkedHashMap.put("UT", DateTimeZone.UTC);
        linkedHashMap.put("UTC", DateTimeZone.UTC);
        linkedHashMap.put("GMT", DateTimeZone.UTC);
        DateTimeUtils.put(linkedHashMap, "EST", "America/New_York");
        DateTimeUtils.put(linkedHashMap, "EDT", "America/New_York");
        DateTimeUtils.put(linkedHashMap, "CST", "America/Chicago");
        DateTimeUtils.put(linkedHashMap, "CDT", "America/Chicago");
        DateTimeUtils.put(linkedHashMap, "MST", "America/Denver");
        DateTimeUtils.put(linkedHashMap, "MDT", "America/Denver");
        DateTimeUtils.put(linkedHashMap, "PST", "America/Los_Angeles");
        DateTimeUtils.put(linkedHashMap, "PDT", "America/Los_Angeles");
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public static final Chronology getInstantChronology(ReadableInstant arg0) {
        if (arg0 == null) {
            return ISOChronology.getInstance();
        }
        Chronology chronology = arg0.getChronology();
        if (chronology == null) {
            return ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final void setDefaultTimeZoneNames(Map<String, DateTimeZone> arg0) {
        cZoneNames.set(Collections.unmodifiableMap(new HashMap<String, DateTimeZone>(arg0)));
    }

    private static void put(Map<String, DateTimeZone> a2, String a3, String a4) {
        try {
            a2.put(a3, DateTimeZone.forID(a4));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    static {
        SYSTEM_MILLIS_PROVIDER = new SystemMillisProvider();
        cMillisProvider = SYSTEM_MILLIS_PROVIDER;
        cZoneNames = new AtomicReference();
    }

    public static final Chronology getIntervalChronology(ReadableInstant arg0, ReadableInstant arg1) {
        Chronology chronology = null;
        if (arg0 != null) {
            chronology = arg0.getChronology();
        } else if (arg1 != null) {
            chronology = arg1.getChronology();
        }
        if (chronology == null) {
            chronology = ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final double toJulianDay(long arg0) {
        double d2 = (double)arg0 / 8.64E7;
        return d2 + 2440587.5;
    }

    public static final long toJulianDayNumber(long arg0) {
        return (long)Math.floor(DateTimeUtils.toJulianDay(arg0) + 0.5);
    }

    public static final Map<String, DateTimeZone> getDefaultTimeZoneNames() {
        Map<String, DateTimeZone> map = cZoneNames.get();
        if (map == null && !cZoneNames.compareAndSet(null, map = DateTimeUtils.buildDefaultTimeZoneNames())) {
            map = cZoneNames.get();
        }
        return map;
    }

    static class OffsetMillisProvider
    implements MillisProvider {
        private final long iMillis;

        OffsetMillisProvider(long a2) {
            OffsetMillisProvider a3;
            a3.iMillis = a2;
        }

        public long getMillis() {
            return System.currentTimeMillis() + this.iMillis;
        }
    }

    static class FixedMillisProvider
    implements MillisProvider {
        private final long iMillis;

        FixedMillisProvider(long a2) {
            FixedMillisProvider a3;
            a3.iMillis = a2;
        }

        public long getMillis() {
            return this.iMillis;
        }
    }

    static class SystemMillisProvider
    implements MillisProvider {
        public long getMillis() {
            return System.currentTimeMillis();
        }

        SystemMillisProvider() {
            SystemMillisProvider a2;
        }
    }

    public static interface MillisProvider {
        public long getMillis();
    }
}

