/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.Comparator;
import org.joda.time.Chronology;
import org.joda.time.DateTimeFieldType;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.InstantConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeComparator
implements Comparator<Object>,
Serializable {
    private static final DateTimeComparator TIME_INSTANCE;
    private static final long serialVersionUID = -6097339773320178364L;
    private static final DateTimeComparator ALL_INSTANCE;
    private final DateTimeFieldType iLowerLimit;
    private final DateTimeFieldType iUpperLimit;
    private static final DateTimeComparator DATE_INSTANCE;

    public String toString() {
        if (this.iLowerLimit == this.iUpperLimit) {
            return "DateTimeComparator[" + (this.iLowerLimit == null ? "" : this.iLowerLimit.getName()) + "]";
        }
        return "DateTimeComparator[" + (this.iLowerLimit == null ? "" : this.iLowerLimit.getName()) + "-" + (this.iUpperLimit == null ? "" : this.iUpperLimit.getName()) + "]";
    }

    public static DateTimeComparator getDateOnlyInstance() {
        return DATE_INSTANCE;
    }

    public DateTimeFieldType getLowerLimit() {
        return this.iLowerLimit;
    }

    static {
        ALL_INSTANCE = new DateTimeComparator(null, null);
        DATE_INSTANCE = new DateTimeComparator(DateTimeFieldType.dayOfYear(), null);
        TIME_INSTANCE = new DateTimeComparator(null, DateTimeFieldType.dayOfYear());
    }

    public int hashCode() {
        return (this.iLowerLimit == null ? 0 : this.iLowerLimit.hashCode()) + 123 * (this.iUpperLimit == null ? 0 : this.iUpperLimit.hashCode());
    }

    public static DateTimeComparator getInstance(DateTimeFieldType arg0) {
        return DateTimeComparator.getInstance(arg0, null);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 instanceof DateTimeComparator) {
            DateTimeComparator dateTimeComparator = (DateTimeComparator)arg0;
            return (this.iLowerLimit == dateTimeComparator.getLowerLimit() || this.iLowerLimit != null && this.iLowerLimit.equals(dateTimeComparator.getLowerLimit())) && (this.iUpperLimit == dateTimeComparator.getUpperLimit() || this.iUpperLimit != null && this.iUpperLimit.equals(dateTimeComparator.getUpperLimit()));
        }
        return false;
    }

    public static DateTimeComparator getInstance(DateTimeFieldType arg0, DateTimeFieldType arg1) {
        if (arg0 == null && arg1 == null) {
            return ALL_INSTANCE;
        }
        if (arg0 == DateTimeFieldType.dayOfYear() && arg1 == null) {
            return DATE_INSTANCE;
        }
        if (arg0 == null && arg1 == DateTimeFieldType.dayOfYear()) {
            return TIME_INSTANCE;
        }
        return new DateTimeComparator(arg0, arg1);
    }

    protected DateTimeComparator(DateTimeFieldType arg0, DateTimeFieldType arg1) {
        this.iLowerLimit = arg0;
        this.iUpperLimit = arg1;
    }

    public static DateTimeComparator getTimeOnlyInstance() {
        return TIME_INSTANCE;
    }

    private Object readResolve() {
        DateTimeComparator a2;
        return DateTimeComparator.getInstance(a2.iLowerLimit, a2.iUpperLimit);
    }

    public static DateTimeComparator getInstance() {
        return ALL_INSTANCE;
    }

    public DateTimeFieldType getUpperLimit() {
        return this.iUpperLimit;
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        InstantConverter instantConverter = ConverterManager.getInstance().getInstantConverter(arg0);
        Chronology chronology = instantConverter.getChronology(arg0, (Chronology)null);
        long l2 = instantConverter.getInstantMillis(arg0, chronology);
        instantConverter = ConverterManager.getInstance().getInstantConverter(arg1);
        Chronology chronology2 = instantConverter.getChronology(arg1, (Chronology)null);
        long l3 = instantConverter.getInstantMillis(arg1, chronology2);
        if (this.iLowerLimit != null) {
            l2 = this.iLowerLimit.getField(chronology).roundFloor(l2);
            l3 = this.iLowerLimit.getField(chronology2).roundFloor(l3);
        }
        if (this.iUpperLimit != null) {
            l2 = this.iUpperLimit.getField(chronology).remainder(l2);
            l3 = this.iUpperLimit.getField(chronology2).remainder(l3);
        }
        if (l2 < l3) {
            return -1;
        }
        if (l2 > l3) {
            return 1;
        }
        return 0;
    }
}

