/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import org.joda.convert.FromString;
import org.joda.time.Chronology;
import org.joda.time.DateMidnight;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.IllegalInstantException;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.TimeOfDay;
import org.joda.time.YearMonthDay;
import org.joda.time.base.BaseDateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class DateTime
extends BaseDateTime
implements ReadableDateTime,
Serializable {
    private static final long serialVersionUID = -5171125899451703815L;

    public Property yearOfCentury() {
        return new Property(this, this.getChronology().yearOfCentury());
    }

    public DateTime withDurationAdded(long arg0, int arg1) {
        if (arg0 == 0L || arg1 == 0) {
            return this;
        }
        long l2 = this.getChronology().add(this.getMillis(), arg0, arg1);
        return this.withMillis(l2);
    }

    public DateTime plusWeeks(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().weeks().add(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public static DateTime now(DateTimeZone arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new DateTime(arg0);
    }

    public DateTime withSecondOfMinute(int arg0) {
        return this.withMillis(this.getChronology().secondOfMinute().set(this.getMillis(), arg0));
    }

    public DateTime(Object arg0) {
        super(arg0, (Chronology)null);
    }

    public Property property(DateTimeFieldType arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        DateTimeField dateTimeField = arg0.getField(this.getChronology());
        if (!dateTimeField.isSupported()) {
            throw new IllegalArgumentException("Field '" + arg0 + "' is not supported");
        }
        return new Property(this, dateTimeField);
    }

    public Property era() {
        return new Property(this, this.getChronology().era());
    }

    public Property dayOfYear() {
        return new Property(this, this.getChronology().dayOfYear());
    }

    public DateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, DateTimeZone arg6) {
        super(arg0, arg1, arg2, arg3, arg4, arg5, 0, arg6);
    }

    public DateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        super(arg0, arg1, arg2, arg3, arg4, arg5, 0);
    }

    public DateTime minusSeconds(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().seconds().subtract(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public Property minuteOfDay() {
        return new Property(this, this.getChronology().minuteOfDay());
    }

    public DateTime(Object arg0, DateTimeZone arg1) {
        super(arg0, arg1);
    }

    public DateTime withDurationAdded(ReadableDuration arg0, int arg1) {
        if (arg0 == null || arg1 == 0) {
            return this;
        }
        return this.withDurationAdded(arg0.getMillis(), arg1);
    }

    public Property secondOfDay() {
        return new Property(this, this.getChronology().secondOfDay());
    }

    public DateTime plus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, 1);
    }

    public DateTime(int arg0, int arg1, int arg2, int arg3, int arg4, DateTimeZone arg5) {
        super(arg0, arg1, arg2, arg3, arg4, 0, 0, arg5);
    }

    public DateTime toDateTime(Chronology arg0) {
        arg0 = DateTimeUtils.getChronology(arg0);
        if (this.getChronology() == arg0) {
            return this;
        }
        return super.toDateTime(arg0);
    }

    public DateTime() {
    }

    public DateTime withTime(int arg0, int arg1, int arg2, int arg3) {
        Chronology chronology = this.getChronology();
        long l2 = chronology.withUTC().getDateTimeMillis(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), arg0, arg1, arg2, arg3);
        return this.withMillis(chronology.getZone().convertLocalToUTC(l2, false, this.getMillis()));
    }

    public DateTime(DateTimeZone arg0) {
        super(arg0);
    }

    public DateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, Chronology arg6) {
        super(arg0, arg1, arg2, arg3, arg4, arg5, 0, arg6);
    }

    public DateTime(Chronology arg0) {
        super(arg0);
    }

    public DateTime withMonthOfYear(int arg0) {
        return this.withMillis(this.getChronology().monthOfYear().set(this.getMillis(), arg0));
    }

    public Property monthOfYear() {
        return new Property(this, this.getChronology().monthOfYear());
    }

    public DateTime withDayOfYear(int arg0) {
        return this.withMillis(this.getChronology().dayOfYear().set(this.getMillis(), arg0));
    }

    public DateTime plusMillis(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().millis().add(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public DateTime minusMillis(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().millis().subtract(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public DateTime withEra(int arg0) {
        return this.withMillis(this.getChronology().era().set(this.getMillis(), arg0));
    }

    public Property weekyear() {
        return new Property(this, this.getChronology().weekyear());
    }

    public DateTime minus(long arg0) {
        return this.withDurationAdded(arg0, -1);
    }

    @Deprecated
    public TimeOfDay toTimeOfDay() {
        return new TimeOfDay(this.getMillis(), this.getChronology());
    }

    public Property minuteOfHour() {
        return new Property(this, this.getChronology().minuteOfHour());
    }

    public DateTime minusHours(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().hours().subtract(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    @Deprecated
    public YearMonthDay toYearMonthDay() {
        return new YearMonthDay(this.getMillis(), this.getChronology());
    }

    public DateTime toDateTime() {
        return this;
    }

    public DateTime plusHours(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().hours().add(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public DateTime minus(ReadableDuration arg0) {
        return this.withDurationAdded(arg0, -1);
    }

    public DateTime withHourOfDay(int arg0) {
        return this.withMillis(this.getChronology().hourOfDay().set(this.getMillis(), arg0));
    }

    public DateTime(long arg0, Chronology arg1) {
        super(arg0, arg1);
    }

    public DateTime minusMonths(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().months().subtract(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public DateTime withWeekyear(int arg0) {
        return this.withMillis(this.getChronology().weekyear().set(this.getMillis(), arg0));
    }

    public DateTime withWeekOfWeekyear(int arg0) {
        return this.withMillis(this.getChronology().weekOfWeekyear().set(this.getMillis(), arg0));
    }

    public static DateTime parse(String arg0, DateTimeFormatter arg1) {
        return arg1.parseDateTime(arg0);
    }

    public Property yearOfEra() {
        return new Property(this, this.getChronology().yearOfEra());
    }

    public LocalDate toLocalDate() {
        return new LocalDate(this.getMillis(), this.getChronology());
    }

    public DateTime plusYears(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().years().add(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public DateTime withDayOfMonth(int arg0) {
        return this.withMillis(this.getChronology().dayOfMonth().set(this.getMillis(), arg0));
    }

    public LocalDateTime toLocalDateTime() {
        return new LocalDateTime(this.getMillis(), this.getChronology());
    }

    public Property millisOfSecond() {
        return new Property(this, this.getChronology().millisOfSecond());
    }

    @FromString
    public static DateTime parse(String arg0) {
        return DateTime.parse(arg0, ISODateTimeFormat.dateTimeParser().withOffsetParsed());
    }

    public DateTime plusSeconds(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().seconds().add(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public Property dayOfMonth() {
        return new Property(this, this.getChronology().dayOfMonth());
    }

    public DateTime minusDays(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().days().subtract(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public DateTime plusMinutes(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().minutes().add(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public DateTime withYearOfCentury(int arg0) {
        return this.withMillis(this.getChronology().yearOfCentury().set(this.getMillis(), arg0));
    }

    public DateTime minus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, -1);
    }

    public DateTime minusWeeks(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().weeks().subtract(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public DateTime withMillisOfSecond(int arg0) {
        return this.withMillis(this.getChronology().millisOfSecond().set(this.getMillis(), arg0));
    }

    public DateTime withChronology(Chronology arg0) {
        return (arg0 = DateTimeUtils.getChronology(arg0)) == this.getChronology() ? this : new DateTime(this.getMillis(), arg0);
    }

    public DateTime(int arg0, int arg1, int arg2, int arg3, int arg4, Chronology arg5) {
        super(arg0, arg1, arg2, arg3, arg4, 0, 0, arg5);
    }

    public static DateTime now(Chronology arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new DateTime(arg0);
    }

    public DateTime withZone(DateTimeZone arg0) {
        return this.withChronology(this.getChronology().withZone(arg0));
    }

    public DateTime withYear(int arg0) {
        return this.withMillis(this.getChronology().year().set(this.getMillis(), arg0));
    }

    public DateTime(int arg0, int arg1, int arg2, int arg3, int arg4) {
        super(arg0, arg1, arg2, arg3, arg4, 0, 0);
    }

    public DateTime plus(ReadableDuration arg0) {
        return this.withDurationAdded(arg0, 1);
    }

    public DateTime withPeriodAdded(ReadablePeriod arg0, int arg1) {
        if (arg0 == null || arg1 == 0) {
            return this;
        }
        long l2 = this.getChronology().add(arg0, this.getMillis(), arg1);
        return this.withMillis(l2);
    }

    public Property dayOfWeek() {
        return new Property(this, this.getChronology().dayOfWeek());
    }

    public DateTime withFields(ReadablePartial arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.withMillis(this.getChronology().set(arg0, this.getMillis()));
    }

    public LocalTime toLocalTime() {
        return new LocalTime(this.getMillis(), this.getChronology());
    }

    public DateTime withMinuteOfHour(int arg0) {
        return this.withMillis(this.getChronology().minuteOfHour().set(this.getMillis(), arg0));
    }

    public DateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {
        super(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public DateTime withMillisOfDay(int arg0) {
        return this.withMillis(this.getChronology().millisOfDay().set(this.getMillis(), arg0));
    }

    public Property centuryOfEra() {
        return new Property(this, this.getChronology().centuryOfEra());
    }

    public DateTime withLaterOffsetAtOverlap() {
        long l2 = this.getZone().adjustOffset(this.getMillis(), true);
        return this.withMillis(l2);
    }

    @Deprecated
    public DateMidnight toDateMidnight() {
        return new DateMidnight(this.getMillis(), this.getChronology());
    }

    public DateTime withMillis(long arg0) {
        return arg0 == this.getMillis() ? this : new DateTime(arg0, this.getChronology());
    }

    public DateTime withZoneRetainFields(DateTimeZone arg0) {
        DateTimeZone dateTimeZone;
        if ((arg0 = DateTimeUtils.getZone(arg0)) == (dateTimeZone = DateTimeUtils.getZone(this.getZone()))) {
            return this;
        }
        long l2 = dateTimeZone.getMillisKeepLocal(arg0, this.getMillis());
        return new DateTime(l2, this.getChronology().withZone(arg0));
    }

    public DateTime withDayOfWeek(int arg0) {
        return this.withMillis(this.getChronology().dayOfWeek().set(this.getMillis(), arg0));
    }

    public DateTime withFieldAdded(DurationFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (arg1 == 0) {
            return this;
        }
        long l2 = arg0.getField(this.getChronology()).add(this.getMillis(), arg1);
        return this.withMillis(l2);
    }

    public DateTime withCenturyOfEra(int arg0) {
        return this.withMillis(this.getChronology().centuryOfEra().set(this.getMillis(), arg0));
    }

    public Property year() {
        return new Property(this, this.getChronology().year());
    }

    public DateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, DateTimeZone arg7) {
        super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public DateTime withTimeAtStartOfDay() {
        return this.toLocalDate().toDateTimeAtStartOfDay(this.getZone());
    }

    public DateTime plus(long arg0) {
        return this.withDurationAdded(arg0, 1);
    }

    public DateTime withYearOfEra(int arg0) {
        return this.withMillis(this.getChronology().yearOfEra().set(this.getMillis(), arg0));
    }

    public DateTime withDate(LocalDate arg0) {
        return this.withDate(arg0.getYear(), arg0.getMonthOfYear(), arg0.getDayOfMonth());
    }

    public DateTime plusDays(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().days().add(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public DateTime withEarlierOffsetAtOverlap() {
        long l2 = this.getZone().adjustOffset(this.getMillis(), false);
        return this.withMillis(l2);
    }

    public Property hourOfDay() {
        return new Property(this, this.getChronology().hourOfDay());
    }

    public Property weekOfWeekyear() {
        return new Property(this, this.getChronology().weekOfWeekyear());
    }

    public DateTime(long arg0, DateTimeZone arg1) {
        super(arg0, arg1);
    }

    public DateTime toDateTimeISO() {
        if (this.getChronology() == ISOChronology.getInstance()) {
            return this;
        }
        return super.toDateTimeISO();
    }

    public DateTime withDate(int arg0, int arg1, int arg2) {
        Chronology chronology = this.getChronology();
        long l2 = chronology.withUTC().getDateTimeMillis(arg0, arg1, arg2, this.getMillisOfDay());
        return this.withMillis(chronology.getZone().convertLocalToUTC(l2, false, this.getMillis()));
    }

    public DateTime withField(DateTimeFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        long l2 = arg0.getField(this.getChronology()).set(this.getMillis(), arg1);
        return this.withMillis(l2);
    }

    public DateTime withTime(LocalTime arg0) {
        return this.withTime(arg0.getHourOfDay(), arg0.getMinuteOfHour(), arg0.getSecondOfMinute(), arg0.getMillisOfSecond());
    }

    public Property millisOfDay() {
        return new Property(this, this.getChronology().millisOfDay());
    }

    public DateTime(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, Chronology arg7) {
        super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public DateTime toDateTime(DateTimeZone arg0) {
        arg0 = DateTimeUtils.getZone(arg0);
        if (this.getZone() == arg0) {
            return this;
        }
        return super.toDateTime(arg0);
    }

    public DateTime(long arg0) {
        super(arg0);
    }

    public static DateTime now() {
        return new DateTime();
    }

    public DateTime(Object arg0, Chronology arg1) {
        super(arg0, DateTimeUtils.getChronology(arg1));
    }

    public DateTime minusMinutes(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().minutes().subtract(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public Property secondOfMinute() {
        return new Property(this, this.getChronology().secondOfMinute());
    }

    public DateTime plusMonths(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().months().add(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public DateTime minusYears(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().years().subtract(this.getMillis(), arg0);
        return this.withMillis(l2);
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private DateTime iInstant;
        private DateTimeField iField;
        private static final long serialVersionUID = -6983323811635733510L;

        public DateTime roundHalfEvenCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfEven(this.iInstant.getMillis()));
        }

        public DateTime roundHalfCeilingCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfCeiling(this.iInstant.getMillis()));
        }

        private void readObject(ObjectInputStream a2) throws IOException, ClassNotFoundException {
            Property a3;
            a3.iInstant = (DateTime)a2.readObject();
            DateTimeFieldType dateTimeFieldType = (DateTimeFieldType)a2.readObject();
            a3.iField = dateTimeFieldType.getField(a3.iInstant.getChronology());
        }

        protected long getMillis() {
            return this.iInstant.getMillis();
        }

        public DateTime addToCopy(long arg0) {
            return this.iInstant.withMillis(this.iField.add(this.iInstant.getMillis(), arg0));
        }

        public DateTime getDateTime() {
            return this.iInstant;
        }

        public DateTime setCopy(int arg0) {
            return this.iInstant.withMillis(this.iField.set(this.iInstant.getMillis(), arg0));
        }

        public DateTime setCopy(String arg0) {
            return this.setCopy(arg0, null);
        }

        public DateTime roundHalfFloorCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfFloor(this.iInstant.getMillis()));
        }

        public DateTime setCopy(String arg0, Locale arg1) {
            return this.iInstant.withMillis(this.iField.set(this.iInstant.getMillis(), arg0, arg1));
        }

        public DateTime addToCopy(int arg0) {
            return this.iInstant.withMillis(this.iField.add(this.iInstant.getMillis(), arg0));
        }

        public DateTime addWrapFieldToCopy(int arg0) {
            return this.iInstant.withMillis(this.iField.addWrapField(this.iInstant.getMillis(), arg0));
        }

        public DateTime withMaximumValue() {
            try {
                return this.setCopy(this.getMaximumValue());
            }
            catch (RuntimeException runtimeException) {
                if (IllegalInstantException.isIllegalInstant(runtimeException)) {
                    long l2 = this.getChronology().getZone().previousTransition(this.getMillis() + 86400000L);
                    return new DateTime(l2, this.getChronology());
                }
                throw runtimeException;
            }
        }

        Property(DateTime a2, DateTimeField a3) {
            Property a4;
            a4.iInstant = a2;
            a4.iField = a3;
        }

        protected Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public DateTime withMinimumValue() {
            try {
                return this.setCopy(this.getMinimumValue());
            }
            catch (RuntimeException runtimeException) {
                if (IllegalInstantException.isIllegalInstant(runtimeException)) {
                    long l2 = this.getChronology().getZone().nextTransition(this.getMillis() - 86400000L);
                    return new DateTime(l2, this.getChronology());
                }
                throw runtimeException;
            }
        }

        public DateTime roundFloorCopy() {
            return this.iInstant.withMillis(this.iField.roundFloor(this.iInstant.getMillis()));
        }

        public DateTimeField getField() {
            return this.iField;
        }

        private void writeObject(ObjectOutputStream a2) throws IOException {
            Property a3;
            a2.writeObject(a3.iInstant);
            a2.writeObject(a3.iField.getType());
        }

        public DateTime roundCeilingCopy() {
            return this.iInstant.withMillis(this.iField.roundCeiling(this.iInstant.getMillis()));
        }
    }
}

