/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.datastructure.univariate.realtime.inttime;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.timeseries.datastructure.univariate.realtime.inttime.IntTimeTimeSeries;
import java.util.Arrays;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimpleTimeSeries
implements IntTimeTimeSeries {
    private final double[] new;

    @Override
    public Iterator<IntTimeTimeSeries.Entry> iterator() {
        return new Iterator<IntTimeTimeSeries.Entry>(){
            private int new = 0;

            @Override
            public IntTimeTimeSeries.Entry next() {
                Double a2 = SimpleTimeSeries.this.new[this.new];
                return new IntTimeTimeSeries.Entry(++this.new, (double)a2);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("time series is immutable");
            }
            {
                1 a3;
            }

            @Override
            public boolean hasNext() {
                return this.new < SimpleTimeSeries.this.new.length;
            }
        };
    }

    @Override
    public double get(int t) {
        return this.new[t - 1];
    }

    public SimpleTimeSeries lag(int nLags) {
        return this.lag(nLags, this.size() - nLags);
    }

    public String toString() {
        int a2 = 20;
        StringBuilder a3 = new StringBuilder();
        a3.append(String.format("length = %d\n", this.new.length));
        for (int a4 = 1; a4 <= this.new.length; ++a4) {
            a3.append(String.format("[%d,] ", a4));
            a3.append(String.format("%f, ", this.new[a4 - 1]));
            if (a4 % 20 != 0) continue;
            a3.append("\n");
        }
        return a3.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleTimeSeries a2 = (SimpleTimeSeries)obj;
        return Arrays.equals(this.new, a2.new);
    }

    public SimpleTimeSeries lag(int nLags, int length) {
        ArgumentAssertion.assertNonNegative(nLags, "nLags");
        int a2 = this.size() - nLags - length + 1;
        ArgumentAssertion.assertTrue(a2 >= 1, "lagged series length is too long", new Object[0]);
        double[] a3 = new double[length];
        for (int a4 = a2; a4 <= this.size() - nLags; ++a4) {
            a3[a4 - a2] = this.new[a4 - 1];
        }
        return new SimpleTimeSeries(a3);
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 41 * a2 + Arrays.hashCode(this.new);
        return a2;
    }

    public SimpleTimeSeries(double[] values) {
        this.new = (double[])values.clone();
    }

    @Override
    public double[] toArray() {
        return (double[])this.new.clone();
    }

    @Override
    public int size() {
        return this.new.length;
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    public SimpleTimeSeries drop(int nItems) {
        return this.lag(0, this.size() - nItems);
    }

    public SimpleTimeSeries diff(int d2) {
        double[] a2 = this.toArray();
        return new SimpleTimeSeries(DoubleUtils.diff(a2, 1, d2));
    }
}

