/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.rank.wilcoxon;

import dev.nm.combinatorics.Counter;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.stat.descriptive.rank.Rank;
import dev.nm.stat.distribution.univariate.NormalDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.test.HypothesisTest;
import dev.nm.stat.test.rank.wilcoxon.WilcoxonSignedRankDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WilcoxonSignedRank
extends HypothesisTest {
    private final double float;
    private final WilcoxonSignedRankDistribution short;
    private final double enum;
    private final boolean false;
    private final ProbabilityDistribution void = new NormalDistribution(0.0, 1.0);
    private final double if;
    private final double new;

    @Override
    public double pValue() {
        double a2 = this.false ? this.short.pValue(this.enum) : 2.0 * Math.min(this.rightOneSidedPvalue(), this.leftOneSidedPvalue());
        return a2;
    }

    @Override
    public String getAlternativeHypothesis() {
        return "the medians are different (not by mu)";
    }

    public WilcoxonSignedRank(double[] sample, int mu) {
        this(sample, null, mu, sample.length < 50);
    }

    public double rightOneSidedPvalue() {
        double a2 = this.false ? this.short.rightOneSidedPvalue(this.enum) : WilcoxonSignedRank.oneSidedPvalue(this.void, this.float);
        return a2;
    }

    public WilcoxonSignedRank(double[] sample) {
        this(sample, 0);
    }

    public double leftOneSidedPvalue() {
        double a2 = this.false ? this.short.cdf(this.enum) : 1.0 - this.rightOneSidedPvalue();
        return a2;
    }

    @Override
    public double statistics() {
        return this.enum;
    }

    public WilcoxonSignedRank(double[] sample1, double[] sample2, double mu, boolean isExact) {
        super(sample1, sample2);
        ArgumentAssertion.assertTrue(sample2 == null || sample2.length == sample1.length, "the two samples must have equal number of observations", new Object[0]);
        ArgumentAssertion.assertTrue(sample1.length > 1, "each sample must have more than 1 observation", new Object[0]);
        this.false = isExact;
        int a2 = sample1.length;
        double[] a3 = new double[a2];
        for (int a4 = 0; a4 < a2; ++a4) {
            a3[a4] = sample1[a4] - (sample2 != null ? sample2[a4] : 0.0) - mu;
        }
        double[] a5 = DoubleArrayMath.abs(a3);
        double[] a6 = new Rank(a5).ranks();
        double a7 = 0.0;
        for (int a8 = 0; a8 < a2; ++a8) {
            a7 += a6[a8] * (double)(a3[a8] > 0.0 ? 1 : 0);
        }
        this.enum = a7;
        this.short = new WilcoxonSignedRankDistribution(a2);
        Counter a9 = new Counter();
        a9.add(a3);
        int a10 = 0;
        for (Double a11 : a9.keySet()) {
            int a12 = a9.count(a11);
            a10 += a12 * (a12 - 1) * (a12 + 1);
        }
        this.if = (double)a2 * ((double)a2 + 1.0) / 4.0;
        this.new = Math.sqrt(((double)(a2 * (a2 + 1)) * ((double)(2 * a2) + 1.0) - 0.5 * (double)a10) / 24.0);
        this.float = (this.enum - this.if) / this.new;
    }

    public WilcoxonSignedRank(double[] sample1, double[] sample2) {
        this(sample1, sample2, 0.0, sample1.length + sample2.length < 50);
    }

    @Override
    public String getNullHypothesis() {
        return "the median are equal (by offset mu)";
    }
}

