/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.mean;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.descriptive.moment.Variance;
import dev.nm.stat.distribution.univariate.TDistribution;
import dev.nm.stat.test.HypothesisTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class T
extends HypothesisTest {
    private final double false;
    private final Variance void;
    private final boolean if;
    private final Variance new;

    public T(double[] sample1, double[] sample2) {
        this(sample1, sample2, false, 0.0);
    }

    public double rightOneSidedPvalue() {
        TDistribution a2 = new TDistribution(this.df());
        double a3 = this.statistics();
        double a4 = T.oneSidedPvalue(a2, a3);
        return a4;
    }

    public double rightConfidenceInterval(double confidence) {
        ArgumentAssertion.assertRangeOpen(confidence, 0.0, 1.0, "confidence level");
        long a2 = this.new.N();
        double a3 = this.new.value();
        long a4 = this.void.N();
        double a5 = this.void.value();
        TDistribution a6 = new TDistribution(this.df());
        return this.mean1() - this.mean2() - a6.quantile(0.95) * Math.sqrt(a3 / (double)a2 + a5 / (double)a4);
    }

    @Override
    public String getNullHypothesis() {
        return "the means are equal";
    }

    @Override
    public double statistics() {
        double a2;
        long a3 = this.new.N();
        double a4 = this.new.value();
        long a5 = this.void.N();
        double a6 = this.void.value();
        if (this.if) {
            double a7 = ((double)(a3 - 1L) * a4 + (double)(a5 - 1L) * a6) / (double)(a3 + a5 - 2L);
            a7 = Math.sqrt(a7);
            a2 = (this.mean1() - this.mean2() - this.false) / a7 / Math.sqrt(1.0 / (double)a3 + (a5 == 1L ? 0.0 : 1.0 / (double)a5));
        } else {
            a2 = (this.mean1() - this.mean2() - this.false) / Math.sqrt(a4 / (double)a3 + a6 / (double)a5);
        }
        return a2;
    }

    public T(double[] sample1, double[] sample2, boolean isEqualVar, double mu) {
        super(new double[0][]);
        this.if = isEqualVar;
        this.false = mu;
        this.new = new Variance(sample1);
        this.void = new Variance(sample2);
    }

    @Override
    public String getAlternativeHypothesis() {
        return "the means are different";
    }

    public T(double[] sample1, double[] sample2, double mu) {
        this(sample1, sample2, false, mu);
    }

    @Override
    public double pValue() {
        double a2 = this.rightOneSidedPvalue();
        double a3 = this.leftOneSidedPvalue();
        double a4 = 2.0 * Math.min(a2, a3);
        return a4;
    }

    public double df() {
        double a2;
        long a3 = this.new.N();
        double a4 = this.new.value();
        long a5 = this.void.N();
        double a6 = this.void.value();
        if (this.if) {
            a2 = a3 + a5 - 2L;
        } else {
            a2 = a4 / (double)a3 + a6 / (double)a5;
            a2 *= a2;
            double a7 = a4 / (double)a3;
            double a8 = a6 / (double)a5;
            a2 /= a7 * a7 / (double)(a3 - 1L) + a8 * a8 / (double)(a5 - 1L);
        }
        return a2;
    }

    public double leftOneSidedPvalue() {
        TDistribution a2 = new TDistribution(this.df());
        double a3 = this.statistics();
        double a4 = a2.cdf(a3);
        return a4;
    }

    public double mean1() {
        return this.new.mean();
    }

    public double mean2() {
        return this.void.mean();
    }

    public double leftConfidenceInterval(double confidence) {
        ArgumentAssertion.assertRangeOpen(confidence, 0.0, 1.0, "confidence level");
        long a2 = this.new.N();
        double a3 = this.new.value();
        long a4 = this.void.N();
        double a5 = this.void.value();
        TDistribution a6 = new TDistribution(this.df());
        return this.mean1() - this.mean2() + a6.quantile(0.95) * Math.sqrt(a3 / (double)a2 + a5 / (double)a4);
    }

    public T(double[] sample, double mu) {
        this(sample, new double[]{0.0}, true, mu);
    }

    public double[] confidenceInterval(double confidence) {
        ArgumentAssertion.assertRangeOpen(confidence, 0.0, 1.0, "confidence level");
        long a2 = this.new.N();
        double a3 = this.new.value();
        long a4 = this.void.N();
        double a5 = this.void.value();
        TDistribution a6 = new TDistribution(this.df());
        double[] a7 = new double[]{this.mean1() - this.mean2() - a6.quantile(0.975) * Math.sqrt(a3 / (double)a2 + a5 / (double)a4), this.mean1() - this.mean2() + a6.quantile(0.975) * Math.sqrt(a3 / (double)a2 + a5 / (double)a4)};
        return a7;
    }
}

