/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.regression.linear;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.SubMatrixRef;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LMProblem {
    private volatile ImmutableMatrix float = null;
    private final boolean short;
    private final ImmutableVector enum;
    private final ImmutableVector false;
    private final ImmutableVector void;
    private final ImmutableMatrix if;
    private final ImmutableMatrix new;

    public LMProblem(Vector y, Matrix X) {
        this(y, X, true, null);
    }

    protected void checkInputs() {
        ArgumentAssertion.assertTrue(this.false.size() == this.if.nRows(), "y and A do not have the same number of rows", new Object[0]);
        if (this.void != null) {
            ArgumentAssertion.assertTrue(this.void.size() == this.false.size(), "weights and y do not have the same number of rows", new Object[0]);
            for (int a2 = 1; a2 <= this.void.size(); ++a2) {
                ArgumentAssertion.assertTrue(this.void.get(a2) >= 0.0, "all weights must be non negative", new Object[0]);
            }
        }
    }

    public LMProblem(Vector y, Matrix X, Vector weights) {
        this(y, X, true, weights);
    }

    public int nObs() {
        return this.if.nRows();
    }

    public ImmutableMatrix wA() {
        return this.new;
    }

    public ImmutableVector weights() {
        return this.void;
    }

    public ImmutableMatrix A() {
        return this.if;
    }

    public LMProblem(Vector y, Matrix X, boolean intercept) {
        this(y, X, intercept, null);
    }

    public ImmutableMatrix invOfwAtwA() {
        if (this.float == null) {
            this.float = new ImmutableMatrix(new Inverse(this.new.t().multiply(this.new), 0.0));
        }
        return this.float;
    }

    public int nExogenousFactors() {
        return this.if.nCols() - (this.short ? 1 : 0);
    }

    public LMProblem(LMProblem that) {
        this.false = new ImmutableVector(that.false);
        this.if = new ImmutableMatrix(that.if);
        this.enum = new ImmutableVector(that.enum);
        this.new = new ImmutableMatrix(that.new);
        this.short = that.short;
        this.void = that.void == null ? null : new ImmutableVector(that.void);
    }

    public ImmutableMatrix X() {
        Matrix a2 = !this.short ? this.if : new SubMatrixRef(this.if, 1, this.if.nRows(), 1, this.if.nCols() - 1);
        return new ImmutableMatrix(a2);
    }

    public boolean intercept() {
        return this.short;
    }

    public ImmutableVector y() {
        return this.false;
    }

    public int nFactors() {
        return this.if.nCols();
    }

    public LMProblem(Vector y, Matrix X, boolean intercept, Vector weights) {
        this.false = !(y instanceof ImmutableVector) ? new ImmutableVector(y) : (ImmutableVector)y;
        this.short = intercept;
        this.if = new ImmutableMatrix(!intercept ? X : MatrixFactory.cbind(X, new DenseMatrix(DoubleUtils.rep(1.0, X.nRows()), X.nRows(), 1)));
        ImmutableVector immutableVector = weights != null ? (!(weights instanceof ImmutableVector) ? new ImmutableVector(weights) : (ImmutableVector)weights) : (this.void = null);
        if (weights != null) {
            Vector a2 = weights.pow(0.5);
            DiagonalMatrix a3 = new DiagonalMatrix(a2.toArray());
            this.new = new ImmutableMatrix(a3.multiply(this.if));
            this.enum = new ImmutableVector(y.multiply(a2));
        } else {
            this.new = this.if;
            this.enum = this.false;
        }
        this.checkInputs();
    }

    public ImmutableVector wy() {
        return this.enum;
    }
}

