/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.random.rng.univariate.gamma;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.random.rng.RNGUtils;
import dev.nm.stat.random.rng.univariate.RandomLongGenerator;
import dev.nm.stat.random.rng.univariate.gamma.RandomGammaGenerator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XiTanLiu2010b
implements RandomGammaGenerator {
    private static final double float = Math.exp(1.0);
    private final double short;
    private final double enum;
    private final double false;
    private final double void;
    private final double if;
    private final RandomLongGenerator new;

    public XiTanLiu2010b(double k2, RandomLongGenerator uniform) {
        ArgumentAssertion.assertRangeLeftOpen(k2, 0.0, 1.0, "shape parameter");
        this.if = k2;
        this.new = uniform;
        this.short = Math.pow(k2 / float, k2 / 2.0);
        this.enum = -2.0 / float;
        this.void = 2.0 * k2 / float / (float - k2);
        this.false = this.void - this.enum;
    }

    public XiTanLiu2010b(double k2) {
        this(k2, RNGUtils.UNIFORM);
    }

    @Override
    public double nextDouble() {
        double a2;
        double a3;
        double a4;
        double a5;
        do {
            a5 = this.new.nextDouble();
            a4 = this.new.nextDouble();
            a4 *= this.false;
            a4 += this.enum;
            a2 = (a4 /= (a5 *= this.short)) / this.if;
            a3 = Math.exp(a2);
        } while (!(2.0 * Math.log(a5) <= a4 - a3));
        if (this.if >= 0.01) {
            return a3;
        }
        return a2;
    }

    @Override
    public void seed(long ... seeds) {
        this.new.seed(seeds);
    }
}

