/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.random.rng.multivariate.mcmc.proposalfunction;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.random.rng.multivariate.NormalRVG;
import dev.nm.stat.random.rng.multivariate.mcmc.proposalfunction.ProposalFunction;
import dev.nm.stat.random.rng.univariate.RandomLongGenerator;
import dev.nm.stat.random.rng.univariate.normal.Zignor2005;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GaussianProposalFunction
extends ProposalFunction {
    private final NormalRVG new;

    public GaussianProposalFunction(double[] sigma, RandomLongGenerator uniform) {
        this(new DiagonalMatrix(sigma), uniform);
    }

    public GaussianProposalFunction(Matrix scale, RandomLongGenerator uniform) {
        super(scale.nCols(), scale.nCols());
        ArgumentAssertion.assertTrue(scale.nCols() == scale.nRows(), "the scale matrix must be square", new Object[0]);
        DenseVector a2 = new DenseVector(scale.nRows(), 0.0);
        Matrix a3 = scale.multiply(scale);
        this.new = new NormalRVG(a2, a3, new Zignor2005(uniform));
    }

    public GaussianProposalFunction(double sigma, int size, RandomLongGenerator uniform) {
        this(DoubleUtils.rep(sigma, size), uniform);
    }

    @Override
    public Vector evaluate(Vector x) {
        double[] a2 = this.new.nextVector();
        DenseVector a3 = new DenseVector(a2);
        return x.add(a3);
    }
}

