/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.random.rng.multivariate.mcmc.metropolis;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.stat.random.rng.univariate.BernoulliTrial;
import dev.nm.stat.random.rng.univariate.RandomLongGenerator;

public final class MetropolisUtils {
    public static double logAcceptanceRatio(RealScalarFunction logf, Vector currentState, Vector proposedState) {
        double a2 = (Double)logf.evaluate(proposedState);
        double a3 = (Double)logf.evaluate(currentState);
        return a2 - a3;
    }

    public static boolean isProposalAccepted(RealScalarFunction logf, RandomLongGenerator uniform, Vector currentState, Vector proposedState) {
        double a2 = MetropolisUtils.logAcceptanceRatio(logf, currentState, proposedState);
        return BernoulliTrial.nextLogTrial(uniform, a2);
    }

    private MetropolisUtils() {
        MetropolisUtils a2;
    }
}

