/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.hmm.mixture.distribution;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.stat.distribution.univariate.PoissonDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.hmm.mixture.distribution.MixtureDistribution;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;
import dev.nm.stat.random.rng.univariate.poisson.Knuth1969;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PoissonMixtureDistribution
implements MixtureDistribution {
    private final Double[] new;

    public Double[] getMStepParams(double[] observations, Vector[] u) {
        int a2 = u.length;
        int a3 = u[0].size();
        Double[] a4 = new Double[this.new.length];
        for (int a5 = 0; a5 < a3; ++a5) {
            double a6 = 0.0;
            double a7 = 0.0;
            for (int a8 = 0; a8 < a2; ++a8) {
                double a9 = u[a8].get(a5 + 1);
                a6 += a9 * observations[a8];
                a7 += a9;
            }
            a4[a5] = a6 / a7;
        }
        return a4;
    }

    @Override
    public RandomNumberGenerator[] newRandomNumberGenerators() {
        RandomNumberGenerator[] a2 = new RandomNumberGenerator[this.new.length];
        for (int a3 = 0; a3 < this.new.length; ++a3) {
            double a4 = this.new[a3];
            a2[a3] = new Knuth1969(a4);
        }
        return a2;
    }

    @Override
    public MixtureDistribution newMixtureDistribution(Object[] param) {
        Double[] a2 = Arrays.copyOf((Double[])param, param.length);
        return new PoissonMixtureDistribution(a2);
    }

    public Double[] getParams() {
        Double[] a2 = Arrays.copyOf(this.new, this.new.length);
        return a2;
    }

    public PoissonMixtureDistribution(Double[] rates) {
        this.new = Arrays.copyOf(rates, rates.length);
    }

    @Override
    public ProbabilityDistribution[] newDistributions() {
        ProbabilityDistribution[] a2 = new ProbabilityDistribution[this.new.length];
        for (int a3 = 0; a3 < this.new.length; ++a3) {
            double a4 = this.new[a3];
            a2[a3] = new PoissonDistribution(a4);
        }
        return a2;
    }
}

