/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.hmm.discrete;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.stat.hmm.ForwardBackwardProcedure;
import dev.nm.stat.hmm.HiddenMarkovModel;
import dev.nm.stat.hmm.discrete.DiscreteHMM;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BaumWelch
extends DiscreteHMM {
    private static DiscreteHMM final(int[] a2, DiscreteHMM a3, int a4) {
        DiscreteHMM a5 = new DiscreteHMM(a3);
        for (int a6 = 0; a6 < a4; ++a6) {
            a5 = BaumWelch.train(a2, a5);
        }
        return a5;
    }

    public static DiscreteHMM train(int[] observations, DiscreteHMM model0) {
        int a2;
        double a3;
        int a4;
        double a5;
        int a6;
        int a7 = observations.length;
        int a8 = model0.nStates();
        int a9 = model0.nSymbols();
        ForwardBackwardProcedure a10 = new ForwardBackwardProcedure((HiddenMarkovModel)model0, observations);
        Matrix[] a11 = BaumWelch.xi(model0, observations, a10);
        Vector[] a12 = BaumWelch.gamma(model0, observations, a11);
        DenseVector a13 = new DenseVector(a8);
        DenseMatrix a14 = new DenseMatrix(a8, a8);
        DenseMatrix a15 = new DenseMatrix(a8, a9);
        for (a6 = 1; a6 <= a8; ++a6) {
            a13.set(a6, a12[1].get(a6));
        }
        for (a6 = 1; a6 <= a8; ++a6) {
            a5 = 0.0;
            for (a4 = 1; a4 <= a7 - 1; ++a4) {
                a5 += a12[a4].get(a6);
            }
            for (a4 = 1; a4 <= a8; ++a4) {
                a3 = 0.0;
                for (a2 = 1; a2 <= a7 - 1; ++a2) {
                    a3 += a11[a2].get(a6, a4);
                }
                a14.set(a6, a4, a3 / a5);
            }
        }
        for (a6 = 1; a6 <= a8; ++a6) {
            a5 = 0.0;
            for (a4 = 1; a4 <= a7 - 1; ++a4) {
                a5 += a12[a4].get(a6);
            }
            for (a4 = 1; a4 <= a9; ++a4) {
                a3 = 0.0;
                for (a2 = 1; a2 <= a7 - 1; ++a2) {
                    if (observations[a2 - 1] != a4) continue;
                    a3 += a12[a2].get(a6);
                }
                a15.set(a6, a4, a3 / a5);
            }
        }
        DiscreteHMM a16 = new DiscreteHMM((Vector)a13, (Matrix)a14, a15);
        return a16;
    }

    public static Vector[] gamma(HiddenMarkovModel model, int[] observations, Matrix[] xi) {
        int a2 = observations.length;
        int a3 = model.nStates();
        Vector[] a4 = new Vector[a2];
        for (int a5 = 1; a5 <= a2 - 1; ++a5) {
            a4[a5] = new DenseVector(a3);
            for (int a6 = 1; a6 <= a3; ++a6) {
                double a7 = 0.0;
                for (int a8 = 1; a8 <= a3; ++a8) {
                    a7 += xi[a5].get(a6, a8);
                }
                a4[a5].set(a6, a7);
            }
        }
        return a4;
    }

    public static Matrix[] xi(HiddenMarkovModel model, int[] observations, ForwardBackwardProcedure fb) {
        int a2 = observations.length;
        int a3 = model.nStates();
        ImmutableMatrix a4 = model.A();
        Matrix[] a5 = new DenseMatrix[a2];
        for (int a6 = 1; a6 <= a2 - 1; ++a6) {
            a5[a6] = new DenseMatrix(a3, a3);
            for (int a7 = 1; a7 <= a3; ++a7) {
                for (int a8 = 1; a8 <= a3; ++a8) {
                    double a9 = fb.scaledAlpha(a6).get(a7);
                    double a10 = fb.scaledBeta(a6 + 1).get(a8);
                    double a11 = a9 * a4.get(a7, a8) * model.density(a8, observations[a6]) * a10;
                    a5[a6].set(a7, a8, a11);
                }
            }
        }
        return a5;
    }

    public BaumWelch(int[] observations, DiscreteHMM model0, int nIteraions) {
        super(BaumWelch.final(observations, model0, nIteraions));
    }
}

