/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.univariate;

import dev.nm.analysis.function.special.gamma.Gamma;
import dev.nm.analysis.function.special.gamma.GammaLanczosQuick;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.evt.evd.univariate.UnivariateEVD;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GeneralizedEVD
implements UnivariateEVD {
    private final double false;
    private static final Gamma void;
    private final double if;
    private final double new;

    private double final(int a2) {
        GeneralizedEVD a3;
        return void.evaluate(1.0 - (double)a2 * a3.false);
    }

    public double getLocation() {
        return this.new;
    }

    public double marginalInverseTransform(double x) {
        if (this.false != 0.0) {
            return (Math.pow(x, -this.false) - 1.0) / this.false * this.if + this.new;
        }
        return this.new - this.if * Math.log(x);
    }

    @Override
    public double quantile(double p) {
        ArgumentAssertion.assertRangeOpen(p, 0.0, 1.0, "probability p");
        return this.marginalInverseTransform(-Math.log(p));
    }

    private boolean final(double a2) {
        GeneralizedEVD a3;
        return 1.0 + a3.false * (a2 - a3.new) / a3.if > 0.0;
    }

    @Override
    public double logDensity(double x) {
        double a2 = (x - this.new) / this.if;
        if (this.false == 0.0) {
            return Math.log(1.0 / this.if) - a2 - Math.exp(-a2);
        }
        double a3 = a2 * this.false + 1.0;
        if (a3 > 0.0 || a3 == Double.NaN) {
            return Math.log(1.0 / this.if) - Math.pow(a3, -1.0 / this.false) - (1.0 / this.false + 1.0) * Math.log(a3);
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double median() {
        if (this.false == 0.0) {
            return this.new - this.if * Math.log(Math.log(2.0));
        }
        return this.new + this.if * (Math.pow(Math.log(2.0), -this.false) - 1.0) / this.false;
    }

    @Override
    public double kurtosis() {
        if (this.false == 0.0) {
            return 2.4;
        }
        double a2 = this.final(1);
        double a3 = this.final(2);
        double a4 = this.final(3);
        double a5 = this.final(4);
        double a6 = a2 * a2;
        double a7 = a6 * a6;
        return (a5 - 4.0 * a2 * a4 + 6.0 * a3 * a6 - 3.0 * a7) / (a3 - a6) / (a3 - a6) - 3.0;
    }

    static {
        Package.validate("NMDEV_EVT");
        void = new GammaLanczosQuick();
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double mean() {
        if (this.false == 0.0) {
            return this.new + this.if * 0.5772156649015329;
        }
        if (this.false < 1.0) {
            return this.new + this.if * (this.final(1) - 1.0) / this.false;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double variance() {
        if (this.false == 0.0) {
            return this.if * this.if * (Math.PI * Math.PI) / 6.0;
        }
        if (this.false < 0.5) {
            double a2 = this.if / this.false;
            double a3 = this.final(1);
            double a4 = this.final(2);
            return a2 * a2 * (a4 - a3 * a3);
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getScale() {
        return this.if;
    }

    @Override
    public double skew() {
        if (this.false == 0.0) {
            return 12.0 * Math.sqrt(6.0) * 1.2020569031595942 / Math.pow(Math.PI, 3.0);
        }
        double a2 = this.final(1);
        double a3 = this.final(2);
        double a4 = this.final(3);
        return (a4 - 3.0 * a2 * a3 + 2.0 * a2 * a2 * a2) / Math.pow(a3 - a2 * a2, 1.5);
    }

    @Override
    public double density(double x) {
        return Math.exp(this.logDensity(x));
    }

    @Override
    public double entropy() {
        double a2 = 0.5772156649015329;
        return Math.log(this.if) + a2 * this.false + (a2 + 1.0);
    }

    @Override
    public double cdf(double x) {
        if (!this.final(x)) {
            return 0.0;
        }
        return Math.exp(-this.marginalTransform(x));
    }

    public GeneralizedEVD(double location, double scale, double shape) {
        ArgumentAssertion.assertPositive(scale, "scale");
        this.new = location;
        this.if = scale;
        this.false = shape;
    }

    public double getShape() {
        return this.false;
    }

    public double marginalTransform(double x) {
        if (this.false != 0.0) {
            return Math.pow(Math.max(1.0 + this.false * (x - this.new) / this.if, 0.0), -1.0 / this.false);
        }
        return Math.exp(-(x - this.new) / this.if);
    }

    public GeneralizedEVD() {
        this(0.0, 1.0, 0.0);
    }
}

