/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.bivariate;

import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.root.univariate.BrentRoot;
import dev.nm.analysis.root.univariate.NoRootFoundException;
import dev.nm.analysis.root.univariate.Uniroot;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;
import dev.nm.misc.license.Package;
import dev.nm.stat.evt.evd.bivariate.AbstractBivariateEVD;
import dev.nm.stat.evt.evd.univariate.GeneralizedEVD;
import dev.nm.stat.random.rng.univariate.uniform.UniformRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateEVDNegativeLogistic
extends AbstractBivariateEVD {
    private final GeneralizedEVD enum;
    private final UniformRNG false = new UniformRNG();
    private final double void;
    private final GeneralizedEVD if;
    private static final Uniroot new;

    public BivariateEVDNegativeLogistic(double dependence, GeneralizedEVD marginal1, GeneralizedEVD marginal2) {
        ArgumentAssertion.assertPositive(dependence, "dependence");
        this.void = dependence;
        this.if = marginal1;
        this.enum = marginal2;
    }

    @Override
    public double cdf(double x1, double x2) {
        double a2 = this.if.marginalTransform(x1);
        double a3 = this.enum.marginalTransform(x2);
        double a4 = a2 + a3 - Math.pow(Math.pow(a2, -this.void) + Math.pow(a3, -this.void), -1.0 / this.void);
        return Math.exp(-a4);
    }

    @Override
    public double dependence(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        return 1.0 - Math.pow(Math.pow(x, -this.void) + Math.pow(1.0 - x, -this.void), -1.0 / this.void);
    }

    @Override
    public double conditionalCopula(double x1, double x2) {
        ArgumentAssertion.assertRangeOpen(x1, 0.0, 1.0, "x1");
        ArgumentAssertion.assertRangeOpen(x2, 0.0, 1.0, "x2");
        return this.final(x1, x2);
    }

    public BivariateEVDNegativeLogistic(double dependence) {
        this(dependence, new GeneralizedEVD());
    }

    public BivariateEVDNegativeLogistic(double dependence, GeneralizedEVD marginal) {
        this(dependence, marginal, marginal);
    }

    @Override
    public double spectralDensity(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        return (1.0 + this.void) * Math.pow(x * (1.0 - x), this.void - 1.0) * Math.pow(Math.pow(x, this.void) + Math.pow(1.0 - x, this.void), -1.0 / this.void - 2.0);
    }

    @Override
    public void seed(long ... seeds) {
        this.false.seed(seeds);
    }

    private double final(double a2, double a3) {
        BivariateEVDNegativeLogistic a4;
        double a5 = -Math.log(a2);
        double a6 = -Math.log(a3);
        double a7 = 1.0 / a4.void;
        double a8 = Math.pow(Math.pow(a6, -a4.void) + Math.pow(a5, -a4.void), -a7);
        double a9 = Math.exp(a8) * a2 * (1.0 - Math.pow(1.0 + Math.pow(a6 / a5, a4.void), -1.0 - a7));
        return a9;
    }

    @Override
    public double density(double x1, double x2) {
        double a2 = this.if.marginalTransform(x1);
        double a3 = this.enum.marginalTransform(x2);
        if (a2 == 0.0 || a3 == 0.0 || Double.isInfinite(a2) || Double.isInfinite(a3)) {
            return 0.0;
        }
        double a4 = 1.0 / this.void;
        double a5 = Math.pow(Math.pow(a2, -this.void) + Math.pow(a3, -this.void), -a4);
        double a6 = a2 + a3 - a5;
        double a7 = Math.log(a2);
        double a8 = Math.log(a3);
        double a9 = (-this.void - 1.0) * a7;
        double a10 = (-this.void - 1.0) * a8;
        double a11 = (1.0 + this.if.getShape()) * a7 + (1.0 + this.enum.getShape()) * a8 - Math.log(this.if.getScale() * this.enum.getScale());
        double a12 = (1.0 + this.void) * Math.log(a5) + Math.log(Math.exp(a9) + Math.exp(a10));
        double a13 = a9 + a10 + (1.0 + 2.0 * this.void) * Math.log(a5) + Math.log(1.0 + this.void + a5);
        double a14 = Math.log(1.0 - Math.exp(a12) + Math.exp(a13)) - a6 + a11;
        return Math.exp(a14);
    }

    @Override
    public double[] nextVector() {
        double a2;
        final double[] a3 = new double[]{this.false.nextDouble(), this.false.nextDouble()};
        AbstractUnivariateRealFunction a4 = new AbstractUnivariateRealFunction(){
            {
                1 a32;
            }

            @Override
            public double evaluate(double x) {
                return BivariateEVDNegativeLogistic.this.final(x, a3[1]) - a3[0];
            }
        };
        try {
            a2 = new.solve(a4, Constants.MACH_EPS, 1.0 - Constants.MACH_EPS, new double[0]);
        }
        catch (NoRootFoundException a5) {
            a2 = a5.x();
        }
        a3[0] = a2;
        double a6 = this.if.marginalInverseTransform(-Math.log(a3[0]));
        double a7 = this.enum.marginalInverseTransform(-Math.log(a3[1]));
        return new double[]{a6, a7};
    }

    static {
        Package.validate("NMDEV_EVT");
        new = new BrentRoot(Constants.EPSILON, Integer.MAX_VALUE);
    }
}

