/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.bivariate;

import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.root.univariate.BrentRoot;
import dev.nm.analysis.root.univariate.NoRootFoundException;
import dev.nm.analysis.root.univariate.Uniroot;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;
import dev.nm.misc.license.Package;
import dev.nm.stat.evt.evd.bivariate.AbstractBivariateEVD;
import dev.nm.stat.evt.evd.univariate.GeneralizedEVD;
import dev.nm.stat.random.rng.univariate.uniform.UniformRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateEVDAsymmetricMixed
extends AbstractBivariateEVD {
    private static final Uniroot short;
    private final GeneralizedEVD enum;
    private final double false;
    private final UniformRNG void = new UniformRNG();
    private final double if;
    private final GeneralizedEVD new;

    public BivariateEVDAsymmetricMixed(double alpha, double beta, GeneralizedEVD marginal) {
        this(alpha, beta, marginal, marginal);
    }

    @Override
    public double[] nextVector() {
        double a2;
        final double[] a3 = new double[]{this.void.nextDouble(), this.void.nextDouble()};
        AbstractUnivariateRealFunction a4 = new AbstractUnivariateRealFunction(){
            {
                1 a32;
            }

            @Override
            public double evaluate(double x) {
                return BivariateEVDAsymmetricMixed.this.final(x, a3[1]) - a3[0];
            }
        };
        try {
            a2 = short.solve(a4, Constants.MACH_EPS, 1.0 - Constants.MACH_EPS, new double[0]);
        }
        catch (NoRootFoundException a5) {
            a2 = a5.x();
        }
        a3[0] = a2;
        double a6 = this.enum.marginalInverseTransform(-Math.log(a3[0]));
        double a7 = this.new.marginalInverseTransform(-Math.log(a3[1]));
        return new double[]{a6, a7};
    }

    @Override
    public double cdf(double x1, double x2) {
        double a2 = this.enum.marginalTransform(x1);
        double a3 = this.new.marginalTransform(x2);
        if (Double.isInfinite(a2) || Double.isInfinite(a3)) {
            return 0.0;
        }
        double a4 = a2 + a3;
        if (a4 == 0.0) {
            return 1.0;
        }
        double a5 = a2 * a2;
        double a6 = a4 - (this.if + this.false) * a2 + this.if * a5 / a4 + this.false * a5 * a2 / a4 / a4;
        return Math.exp(-a6);
    }

    @Override
    public double conditionalCopula(double x1, double x2) {
        ArgumentAssertion.assertRangeOpen(x1, 0.0, 1.0, "x1");
        ArgumentAssertion.assertRangeOpen(x2, 0.0, 1.0, "x2");
        return this.final(x1, x2);
    }

    public BivariateEVDAsymmetricMixed(double alpha, double beta, GeneralizedEVD marginal1, GeneralizedEVD marginal2) {
        ArgumentAssertion.assertNonNegative(alpha, "alpha");
        ArgumentAssertion.assertNotGreaterThan(alpha + beta, 1.0, "alpha + beta");
        ArgumentAssertion.assertNotGreaterThan(alpha + 2.0 * beta, 1.0, "alpha + 2*beta");
        ArgumentAssertion.assertNonNegative(alpha + 3.0 * beta, "alpha + 3*beta");
        this.if = alpha;
        this.false = beta;
        this.enum = marginal1;
        this.new = marginal2;
    }

    @Override
    public double dependence(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        return 1.0 - (this.if + this.false) * x + this.if * x * x + this.false * x * x * x;
    }

    static {
        Package.validate("NMDEV_EVT");
        short = new BrentRoot(Constants.EPSILON, Integer.MAX_VALUE);
    }

    private double final(double a2, double a3) {
        BivariateEVDAsymmetricMixed a4;
        double a5 = -Math.log(a2);
        double a6 = -Math.log(a3);
        double a7 = a5 / (a5 + a6);
        double a8 = a5 + a6 - a5 * (a4.if + a4.false - a4.if * a7 - a4.false * a7 * a7);
        double a9 = 1.0 - a4.if * a7 * a7 - 2.0 * a4.false * a7 * a7 * a7;
        double a10 = Math.exp(-a8) * (1.0 / a3) * a9;
        return a10;
    }

    public BivariateEVDAsymmetricMixed(double alpha, double beta) {
        this(alpha, beta, new GeneralizedEVD());
    }

    @Override
    public double spectralDensity(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        return 2.0 * this.if + 6.0 * this.false * (1.0 - x);
    }

    @Override
    public void seed(long ... seeds) {
        this.void.seed(seeds);
    }

    @Override
    public double density(double x1, double x2) {
        double a2;
        double a3 = this.enum.marginalTransform(x1);
        double a4 = this.new.marginalTransform(x2);
        if (a3 == 0.0 || a4 == 0.0 || Double.isInfinite(a3) || Double.isInfinite(a4)) {
            a2 = Double.NEGATIVE_INFINITY;
        } else {
            double a5 = a3 + a4;
            double a6 = a5 - (this.if + this.false) * a3 + this.if * a3 * a3 / a5 + this.false * a3 * a3 * a3 / a5 / a5;
            double a7 = Math.log(a3);
            double a8 = Math.log(a4);
            double a9 = (1.0 + this.enum.getShape()) * a7 + (1.0 + this.new.getShape()) * a8 - Math.log(this.enum.getScale() * this.new.getScale());
            double a10 = a3 / a5;
            double a11 = a4 / a5;
            double a12 = 1.0 - this.if * a11 * a11 - this.false * (3.0 * a11 * a11 - 2.0 * a11 * a11 * a11);
            double a13 = 1.0 - this.if * a10 * a10 - 2.0 * this.false * a10 * a10 * a10;
            double a14 = (-2.0 * this.if * a10 * a11 - 6.0 * this.false * a10 * a10 * a11) / a5;
            a2 = Math.log(a12 * a13 - a14) - a6 + a9;
        }
        return Math.exp(a2);
    }
}

