/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.dlm.univariate;

import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.random.rng.RNGUtils;
import dev.nm.stat.random.rng.univariate.normal.RandomStandardNormalGenerator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StateEquation {
    private final RandomStandardNormalGenerator false;
    private final UnivariateRealFunction void;
    private final UnivariateRealFunction if;
    private final UnivariateRealFunction new;

    public StateEquation(UnivariateRealFunction G2, UnivariateRealFunction W) {
        this(G2, new AbstractUnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double x) {
                return 0.0;
            }
        }, W);
    }

    public double H(int t) {
        return this.if.evaluate(t);
    }

    public StateEquation(UnivariateRealFunction G2, UnivariateRealFunction H2, UnivariateRealFunction W, RandomStandardNormalGenerator rnorm) {
        ArgumentAssertion.assertTrue(G2.dimensionOfDomain() == H2.dimensionOfDomain() && H2.dimensionOfDomain() == W.dimensionOfDomain(), "the domain dimensions of F and V and W must match", new Object[0]);
        this.void = G2;
        this.if = H2;
        this.new = W;
        this.false = rnorm;
    }

    public double xt_mean(int t, double xt_1) {
        return this.xt_mean(t, xt_1, 0.0);
    }

    public int dimension() {
        return 1;
    }

    public double xt_var(int t, double var_tlag_tlag) {
        double a2 = this.G(t);
        double a3 = this.W(t);
        double a4 = a2 * var_tlag_tlag * a2 + a3;
        return a4;
    }

    public StateEquation(final double G2, final double H2, final double W, RandomStandardNormalGenerator rnorm) {
        this(new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return G2;
            }
            {
                2 a2;
            }
        }, new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return H2;
            }
            {
                3 a2;
            }
        }, new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return W;
            }
            {
                4 a2;
            }
        }, rnorm);
    }

    public StateEquation(double G2, double W) {
        this(G2, 0.0, W, RNGUtils.RNORM);
    }

    public StateEquation(UnivariateRealFunction G2, UnivariateRealFunction H2, UnivariateRealFunction W) {
        this(G2, H2, W, RNGUtils.RNORM);
    }

    public double G(int t) {
        return this.void.evaluate(t);
    }

    public StateEquation(StateEquation that) {
        this(that.void, that.if, that.new);
    }

    public double W(int t) {
        return this.new.evaluate(t);
    }

    public double xt_mean(int t, double xt_1, double ut) {
        double a2 = this.void.evaluate(t) * xt_1;
        if (this.if != null) {
            double a3 = this.if.evaluate(t) * ut;
            a2 += a3;
        }
        return a2;
    }

    public double xt(int t, double xt_1, double ut) {
        double a2 = this.xt_mean(t, xt_1, ut);
        double a3 = this.false.nextDouble() * Math.sqrt(this.new.evaluate(t));
        return a2 += a3;
    }

    public double xt(int t, double xt_1) {
        return this.xt(t, xt_1, 0.0);
    }
}

