/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.dlm.multivariate;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky.CholeskyWang2006;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.CongruentMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.matrix.R1toConstantMatrix;
import dev.nm.analysis.function.matrix.R1toMatrix;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import dev.nm.misc.license.Package;
import dev.nm.stat.dlm.univariate.StateEquation;
import dev.nm.stat.random.rng.multivariate.NormalRVG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateStateEquation {
    private final NormalRVG enum;
    private final int false;
    private final R1toMatrix void;
    private final R1toMatrix if;
    private final R1toMatrix new;

    public MultivariateStateEquation(R1toMatrix G2, R1toMatrix H2, R1toMatrix W, NormalRVG rmvnorm) {
        this.false = G2.evaluate(1.0).nRows();
        ArgumentAssertion.assertTrue(W.evaluate(1.0).nRows() == this.false && W.evaluate(1.0).nCols() == this.false, "the dimension of W is the dimension of each state x_t", new Object[0]);
        if (H2 != null) {
            ArgumentAssertion.assertTrue(H2.evaluate(1.0).nRows() == this.false, "the dimension of W is the dimension of each state x_t", new Object[0]);
        }
        this.if = G2;
        this.new = H2;
        this.void = W;
        this.enum = rmvnorm == null ? new NormalRVG(this.false) : rmvnorm;
    }

    public Matrix H(int t) {
        return this.new != null ? this.new.evaluate(t) : null;
    }

    public MultivariateStateEquation(Matrix G2, Matrix H2, Matrix W, NormalRVG rmvnorm) {
        this(new R1toConstantMatrix(G2), H2 != null ? new R1toConstantMatrix(H2) : null, new R1toConstantMatrix(W), rmvnorm);
    }

    public int dimension() {
        return this.false;
    }

    public MultivariateStateEquation(Matrix G2, Matrix W) {
        this(G2, null, W, null);
    }

    public MultivariateStateEquation(R1toMatrix G2, R1toMatrix H2, R1toMatrix W) {
        this(G2, H2, W, null);
    }

    public MultivariateStateEquation(R1toMatrix G2, R1toMatrix W) {
        this(G2, null, W);
    }

    public Matrix W(int t) {
        return this.void.evaluate(t);
    }

    public ImmutableMatrix xt_var(int t, Matrix var_tlag_tlag) {
        Matrix a2 = this.G(t);
        Matrix a3 = this.W(t);
        Matrix a4 = new CongruentMatrix(a2.t(), var_tlag_tlag).add(a3);
        return new ImmutableMatrix(a4);
    }

    static {
        Package.validate("NMDEV_STAT");
    }

    public Vector xt_mean(int t, Vector xt_1, Vector ut) {
        Vector a2 = this.if.evaluate(t).multiply(xt_1);
        if (this.new != null) {
            Vector a3 = this.new.evaluate(t).multiply(ut);
            a2 = a2.add(a3);
        }
        return a2;
    }

    public Matrix G(int t) {
        return this.if.evaluate(t);
    }

    public MultivariateStateEquation(MultivariateStateEquation that) {
        this(that.if, that.new, that.void);
    }

    public ImmutableVector xt(int t, Vector xt_1) {
        ArgumentAssertion.assertTrue(this.new == null, "H is not null and thus it requires the control variable", new Object[0]);
        return this.xt(t, xt_1, null);
    }

    public ImmutableVector xt(int t, Vector xt_1, Vector ut) {
        Vector a2 = this.xt_mean(t, xt_1, ut);
        Matrix a3 = this.void.evaluate(t);
        LowerTriangularMatrix a4 = new CholeskyWang2006(a3, PrecisionUtils.autoEpsilon(MatrixUtils.to1DArray(a3))).L();
        Vector a5 = a4.multiply(new DenseVector(this.enum.nextVector()));
        a2 = a2.add(a5);
        return new ImmutableVector(a2);
    }

    public Vector xt_mean(int t, Vector xt_1) {
        return this.xt_mean(t, xt_1, null);
    }

    public MultivariateStateEquation(final StateEquation states) {
        this(new R1toMatrix(){

            @Override
            public Matrix evaluate(double t) {
                return new DenseMatrix(new double[][]{{states.G((int)t)}});
            }
            {
                1 a2;
            }
        }, new R1toMatrix(){
            {
                2 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                return new DenseMatrix(new double[][]{{states.H((int)t)}});
            }
        }, new R1toMatrix(){
            {
                3 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                return new DenseMatrix(new double[][]{{states.W((int)t)}});
            }
        });
    }
}

