/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.misc.Constants;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TriangularDistribution
implements ProbabilityDistribution {
    private final double void;
    private final double if;
    private final double new;

    @Override
    public double entropy() {
        double a2 = 0.5;
        return a2 += Math.log((this.new - this.if) / 2.0);
    }

    @Override
    public double density(double x) {
        if (x < this.if || x > this.new) {
            return 0.0;
        }
        if (this.if <= x && x <= this.void) {
            return 2.0 * (x - this.if) / ((this.new - this.if) * (this.void - this.if));
        }
        return 2.0 * (this.new - x) / ((this.new - this.if) * (this.new - this.void));
    }

    @Override
    public double kurtosis() {
        return -0.6;
    }

    public TriangularDistribution(double min, double mode, double max) {
        this.if = min;
        this.void = mode;
        this.new = max;
    }

    @Override
    public double moment(double t) {
        double a2 = 2.0 * (this.new - this.void) * Math.exp(this.if * t);
        a2 -= (this.new - this.if) * Math.exp(this.void * t);
        a2 -= (this.void - this.if) * Math.exp(this.new * t);
        return a2 /= (this.new - this.if) * (this.void - this.if) * (this.new - this.void) / t / t;
    }

    @Override
    public double cdf(double x) {
        if (x < this.if) {
            return 0.0;
        }
        if (this.if <= x && x <= this.void) {
            return (x - this.if) * (x - this.if) / ((this.new - this.if) * (this.void - this.if));
        }
        if (this.void < x && x <= this.new) {
            return 1.0 - (this.new - x) * (this.new - x) / ((this.new - this.if) * (this.new - this.void));
        }
        return 1.0;
    }

    @Override
    public double skew() {
        double a2 = Constants.ROOT_2;
        a2 *= (this.if + this.new - 2.0 * this.void) * (2.0 * this.if - this.new - this.void) * (this.if - 2.0 * this.new + this.void);
        a2 /= Math.pow(this.if * this.if + this.new * this.new + this.void * this.void - this.if * this.new - this.if * this.void - this.new * this.void, 1.5);
        return a2 /= 5.0;
    }

    @Override
    public double quantile(double u) {
        if (u <= (this.void - this.if) / (this.new - this.if)) {
            return this.if + Math.sqrt(u * (this.new - this.if) * (this.void - this.if));
        }
        return this.new - Math.sqrt((1.0 - u) * (this.new - this.if) * (this.new - this.void));
    }

    @Override
    public double variance() {
        double a2 = this.if * this.if + this.new * this.new + this.void * this.void - this.if * this.new - this.if * this.void - this.new * this.void;
        return a2 /= 18.0;
    }

    @Override
    public double median() {
        double a2 = (this.if + this.new) / 2.0;
        if (this.void >= a2) {
            double a3 = (this.new - this.if) * (this.void - this.if) / 2.0;
            a3 = Math.sqrt(a3);
            return a3 += this.if;
        }
        double a4 = (this.new - this.if) * (this.new - this.void) / 2.0;
        a4 = Math.sqrt(a4);
        a4 = this.new - a4;
        return a4;
    }

    @Override
    public double mean() {
        double a2 = this.if + this.new + this.void;
        return a2 /= 3.0;
    }
}

