/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.analysis.function.special.gaussian.Erf;
import dev.nm.misc.Constants;
import dev.nm.misc.license.Package;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RayleighDistribution
implements ProbabilityDistribution {
    private final double new;

    @Override
    public double skew() {
        return 2.0 * Constants.ROOT_PI * 0.14159265358979312 / Math.pow(0.8584073464102069, 1.5);
    }

    @Override
    public double median() {
        return this.new * Math.sqrt(Math.log(4.0));
    }

    @Override
    public double quantile(double u) {
        return this.new * Math.sqrt(-2.0 * Math.log(1.0 - u));
    }

    @Override
    public double entropy() {
        return 1.0 + Math.log(this.new / Constants.ROOT_2) + 0.28860783245076643;
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    @Override
    public double density(double x) {
        assert (x >= 0.0) : "x must be positive";
        return x / this.new / this.new * Math.exp(-x * x / 2.0 / this.new / this.new);
    }

    @Override
    public double kurtosis() {
        return 0.2450893006876391;
    }

    @Override
    public double moment(double t) {
        Erf a2 = new Erf();
        return 1.0 + this.new * t * Math.exp(this.new * this.new * t * t / 2.0) * Math.sqrt(1.5707963267948966) * (a2.evaluate(this.new * t / Constants.ROOT_2) + 1.0);
    }

    public RayleighDistribution(double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma must be > 0");
        }
        this.new = sigma;
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be non-negative";
        return 1.0 - Math.exp(-x * x / 2.0 / this.new / this.new);
    }

    @Override
    public double mean() {
        return this.new * Math.sqrt(1.5707963267948966);
    }

    @Override
    public double variance() {
        return this.new * this.new * 0.8584073464102069 / 2.0;
    }
}

