/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.analysis.sequence.Summation;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PoissonDistribution
implements ProbabilityDistribution {
    private final double new;

    @Override
    public double quantile(double u) {
        int a2 = 0;
        while (!(this.cdf(a2) >= u)) {
            ++a2;
        }
        return a2;
    }

    @Override
    public double skew() {
        return 1.0 / Math.sqrt(this.new);
    }

    double entropy1() {
        PoissonDistribution a2;
        double a3 = a2.new * (1.0 - Math.log(a2.new));
        Summation a4 = new Summation(new Summation.Term(){
            {
                1 a3;
            }

            @Override
            public double evaluate(double k2) {
                double a2 = 1.0;
                int a3 = 1;
                while ((double)a3 <= k2) {
                    a2 *= PoissonDistribution.this.new / (double)a3;
                    ++a3;
                }
                double a22 = 0.0;
                int a4 = 1;
                while ((double)a4 <= k2) {
                    a22 += Math.log(a4);
                    ++a4;
                }
                return a2 * a22;
            }
        }, 1.0E-8);
        double a5 = a4.sumToInfinity(2.0, 1.0);
        return a3 += Math.exp(-a2.new) * a5;
    }

    @Override
    public double median() {
        return (int)(this.new + 0.3333333333333333 - 0.02 * this.new);
    }

    @Override
    public double mean() {
        return this.new;
    }

    @Override
    public double cdf(double k2) {
        double a2 = 0.0;
        double a3 = 1.0;
        a2 += a3;
        int a4 = 1;
        while ((double)a4 <= k2) {
            a2 += (a3 *= this.new / (double)a4);
            ++a4;
        }
        return a2 *= Math.exp(-this.new);
    }

    @Override
    public double entropy() {
        if (this.new < 10.0) {
            return this.entropy1();
        }
        return this.entropy2();
    }

    @Override
    public double density(double k2) {
        assert (k2 >= 0.0) : "x must be >= 0";
        double a2 = Math.exp(-this.new);
        for (int a3 = 1; a3 <= (int)k2; ++a3) {
            a2 *= this.new / (double)a3;
        }
        return a2;
    }

    @Override
    public double kurtosis() {
        return 1.0 / this.new;
    }

    double entropy2() {
        PoissonDistribution a2;
        double a3 = 0.5 * Math.log(Math.PI * 2 * Math.exp(1.0) * a2.new);
        a3 -= 0.08333333333333333 / a2.new;
        a3 -= 0.041666666666666664 / a2.new / a2.new;
        return a3 -= 0.05277777777777778 / a2.new / a2.new / a2.new;
    }

    @Override
    public double moment(double t) {
        double a2 = Math.exp(t) - 1.0;
        a2 *= this.new;
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double variance() {
        return this.new;
    }

    public PoissonDistribution(double lambda) {
        ArgumentAssertion.assertPositive(lambda, "lambda");
        this.new = lambda;
    }

    public double ccdf(double x) {
        return 1.0 - this.cdf(x);
    }

    static {
        Package.validate("NMDEV_BASIC");
    }
}

