/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.analysis.function.special.gamma.GammaRegularizedP;
import dev.nm.analysis.function.special.gamma.GammaRegularizedPInverse;
import dev.nm.analysis.function.special.gamma.LogGamma;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GammaDistribution
implements ProbabilityDistribution {
    private static final GammaRegularizedP enum;
    private static final GammaRegularizedPInverse false;
    private final double void;
    private final double if;
    private static final LogGamma new;

    @Override
    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double skew() {
        return 2.0 / Math.sqrt(this.if);
    }

    @Override
    public double variance() {
        return this.if * this.void * this.void;
    }

    public GammaDistribution(double k2, double theta) {
        ArgumentAssertion.assertPositive(k2, "k");
        ArgumentAssertion.assertPositive(theta, "theta");
        this.if = k2;
        this.void = theta;
    }

    @Override
    public double mean() {
        return this.if * this.void;
    }

    @Override
    public double median() {
        throw new UnsupportedOperationException("There is no simple closed form.");
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be non-negative";
        return enum.evaluate(this.if, x / this.void);
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (DoubleUtils.isZero(x, 0.0) && this.if < 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (DoubleUtils.isZero(x, 0.0) && this.if == 1.0) {
            return Math.exp(-new.evaluate(this.if) - this.if * Math.log(this.void));
        }
        double a2 = (this.if - 1.0) * Math.log(x) - x / this.void - this.if * Math.log(this.void) - new.evaluate(this.if);
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double quantile(double u) {
        return this.void * false.evaluate(this.if, u);
    }

    @Override
    public double moment(double t) {
        ArgumentAssertion.assertTrue(t < 1.0 / this.void, "only for t < 1/theta", new Object[0]);
        return Math.pow(1.0 - this.void * t, -this.if);
    }

    @Override
    public double kurtosis() {
        return 6.0 / this.if;
    }

    static {
        new = new LogGamma();
        enum = new GammaRegularizedP();
        false = new GammaRegularizedPInverse();
    }
}

