/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.misc.license.Package;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExponentialDistribution
implements ProbabilityDistribution {
    private final double new;

    @Override
    public double mean() {
        return 1.0 / this.new;
    }

    @Override
    public double density(double x) {
        double a2 = x < 0.0 ? 0.0 : this.new * Math.exp(-this.new * x);
        return a2;
    }

    @Override
    public double entropy() {
        return 1.0 - Math.log(this.new);
    }

    @Override
    public double quantile(double u) {
        double a2 = -Math.log(1.0 - u) / this.new;
        return a2;
    }

    @Override
    public double skew() {
        return 2.0;
    }

    public ExponentialDistribution(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda > 0");
        }
        this.new = lambda;
    }

    @Override
    public double cdf(double x) {
        double a2 = x < 0.0 ? 0.0 : 1.0 - Math.exp(-this.new * x);
        return a2;
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    @Override
    public double variance() {
        return 1.0 / this.new / this.new;
    }

    @Override
    public double kurtosis() {
        return 6.0;
    }

    @Override
    public double moment(double t) {
        double a2 = 1.0 - t / this.new;
        a2 = 1.0 / a2;
        return a2;
    }

    @Override
    public double median() {
        return Math.log(2.0) / this.new;
    }

    public ExponentialDistribution() {
        this(1.0);
    }
}

