/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.analysis.function.special.gamma.Digamma;
import dev.nm.analysis.function.special.gamma.GammaRegularizedP;
import dev.nm.analysis.function.special.gamma.GammaRegularizedPInverse;
import dev.nm.analysis.function.special.gamma.LogGamma;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChiSquareDistribution
implements ProbabilityDistribution {
    private static final Digamma enum;
    private final double false;
    private static final GammaRegularizedP void;
    private static final LogGamma if;
    private static final GammaRegularizedPInverse new;

    @Override
    public double variance() {
        return 2.0 * this.false;
    }

    @Override
    public double moment(double t) {
        ArgumentAssertion.assertLessThan(t, 0.5, "t");
        return Math.pow(1.0 - 2.0 * t, -this.false / 2.0);
    }

    @Override
    public double kurtosis() {
        return 12.0 / this.false;
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (DoubleUtils.isZero(x, 0.0) && this.false < 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (DoubleUtils.isZero(x, 0.0) && this.false == 2.0) {
            return 0.5;
        }
        double a2 = Math.pow(0.5, this.false / 2.0);
        double a3 = (this.false / 2.0 - 1.0) * Math.log(x) - x / 2.0 - if.evaluate(this.false / 2.0);
        return a2 *= Math.exp(a3);
    }

    @Override
    public double median() {
        return this.false - 0.0 + 0.0 / this.false - 0.0 / this.false / this.false;
    }

    public ChiSquareDistribution(double k2) {
        ArgumentAssertion.assertPositive(k2, "k");
        this.false = k2;
    }

    @Override
    public double entropy() {
        return this.false / 2.0 + Math.log(2.0) + if.evaluate(this.false / 2.0) + (1.0 - this.false / 2.0) * enum.evaluate(this.false / 2.0);
    }

    @Override
    public double quantile(double u) {
        return 2.0 * new.evaluate(this.false / 2.0, u);
    }

    static {
        if = new LogGamma();
        void = new GammaRegularizedP();
        new = new GammaRegularizedPInverse();
        enum = new Digamma();
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be non-negative";
        return void.evaluate(this.false / 2.0, x / 2.0);
    }

    @Override
    public double mean() {
        return this.false;
    }

    @Override
    public double skew() {
        return Math.sqrt(8.0 / this.false);
    }
}

