/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.descriptive.moment;

import dev.nm.analysis.function.FunctionOps;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.descriptive.Statistic;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Moments
implements Statistic {
    private double[] void;
    private long if = 0L;
    private final int new;

    public static double sumsOfPowersOfDifferences(int power, double mean, double ... data) {
        double a2 = 0.0;
        for (double a3 : data) {
            double a4 = a3 - mean;
            a2 += power == 1 ? a4 : Math.pow(a4, power);
        }
        return a2;
    }

    @Override
    public long N() {
        return this.if;
    }

    public Moments(int order) {
        this.new = order;
        this.void = new double[order];
    }

    @Override
    public double value() {
        return this.centralMoment(this.new);
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    public Moments(Moments that) {
        this.new = that.new;
        this.if = that.if;
        this.void = Arrays.copyOf(that.void, that.void.length);
    }

    @Override
    public void addData(double ... data) {
        if (this.if == 0L) {
            this.if = data.length;
            this.void[0] = Moments.sumsOfPowersOfDifferences(1, 0.0, data);
            double a2 = this.void[0] / (double)this.if;
            for (int a3 = 2; a3 <= this.new; ++a3) {
                this.void[a3 - 1] = Moments.sumsOfPowersOfDifferences(a3, a2, data);
            }
            return;
        }
        Moments a4 = new Moments(this);
        Moments a5 = new Moments(this.new, data);
        long a6 = a4.if + a5.if;
        double a7 = a5.void[0] / (double)a5.if - a4.void[0] / (double)a4.if;
        this.void[0] = a4.void[0] + a5.void[0];
        for (int a8 = 2; a8 <= this.new; ++a8) {
            double a9 = 0.0;
            for (int a10 = 1; a10 <= a8 - 2; ++a10) {
                int a11 = a8 - a10;
                double a12 = Math.pow((double)(-a5.if) / (double)a6, a10) * a4.void[a11 - 1];
                a12 += Math.pow((double)a4.if / (double)a6, a10) * a5.void[a11 - 1];
                a12 *= Math.pow(a7, a10);
                a9 += (a12 *= FunctionOps.combination(a8, a10));
            }
            double a13 = (double)a4.if / (double)a6;
            a13 *= a7 * (double)a5.if;
            a13 = Math.pow(a13, a8);
            this.void[a8 - 1] = a4.void[a8 - 1] + a5.void[a8 - 1] + a9 + (a13 *= 1.0 / Math.pow(a5.if, a8 - 1) - Math.pow(-1.0 / (double)a4.if, a8 - 1));
        }
        this.if = a6;
    }

    public double centralMoment(int k2) {
        ArgumentAssertion.assertTrue(k2 <= this.new, "only up to the %d moment are available", this.new);
        double a2 = this.void[k2 - 1] / (double)this.if;
        return a2;
    }

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        for (int a3 = 0; a3 < this.void.length; ++a3) {
            a2.append(String.format("m[%d]: %f; ", a3, this.void[a3]));
        }
        return a2.toString();
    }

    public Moments(int order, double ... data) {
        this(order);
        this.addData(data);
    }
}

