/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.covariance.nlshrink;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.EigenDecomposition;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.covariance.LedoitWolf2004;
import dev.nm.stat.covariance.nlshrink.NonlinearShrinkageEstimator;
import dev.nm.stat.covariance.nlshrink.TauEstimator;
import dev.nm.stat.descriptive.covariance.SampleCovariance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LedoitWolf2016 {
    private final boolean new;

    public LedoitWolf2016() {
        this(true);
    }

    static {
        Package.validate("NMDEV_LEDOITWOLF2016");
    }

    public LedoitWolf2016(boolean unbiased) {
        this.new = unbiased;
    }

    public Result estimate(Matrix Y) {
        return new Result(Y, this.new);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Result {
        private final Vector short;
        private final Vector enum;
        private final EigenDecomposition false;
        private final Vector void;
        private final Matrix if;
        private final Vector new;

        public Vector nlshrink_tau() {
            return new ImmutableVector(this.void);
        }

        public ImmutableMatrix S() {
            return new ImmutableMatrix(this.if);
        }

        private Result(Matrix a2, boolean a3) {
            Result a4;
            int a5 = a2.nCols();
            int a6 = a2.nRows();
            a4.if = new SampleCovariance(a2, a3);
            a4.false = new EigenDecomposition(a4.if);
            a4.new = a4.false.D().getDiagonal();
            for (int a7 = 1; a7 <= a5; ++a7) {
                if (!(a4.new.get(a7) < 0.0)) continue;
                a4.new.set(a7, 0.0);
            }
            Matrix a8 = new LedoitWolf2004().compute(a2).getCovarianceMatrix();
            EigenDecomposition a9 = new EigenDecomposition(a8);
            a4.enum = a9.D().getDiagonal();
            a4.short = new TauEstimator(a5, a6, a4.new).estimatedPopulationEigenvalues(a4.enum);
            a4.void = new NonlinearShrinkageEstimator(a4.short, a6 - 1).nonlinearShrunkEigenvalues();
        }

        public Vector lambda() {
            return new ImmutableVector(this.new);
        }

        public Vector linshrink_tau() {
            return new ImmutableVector(this.enum);
        }

        public Vector tau() {
            return new ImmutableVector(this.short);
        }

        public Matrix getShrunkCovarianceMatrix() {
            int a2 = this.new.size();
            int[] a3 = DoubleUtils.order(this.new.toArray());
            double[] a4 = new double[a2];
            for (int a5 = 0; a5 < a2; ++a5) {
                a4[a5] = this.void.get(a3[a5]);
            }
            DiagonalMatrix a6 = new DiagonalMatrix(a4);
            Matrix a7 = this.false.Q();
            Matrix a8 = this.false.Qt();
            Matrix a9 = a7.multiply(a6).multiply(a8);
            return a9;
        }
    }
}

