/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.unconstrained.c2.steepestdescent;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.matrix.doubles.operation.positivedefinite.GoldfeldQuandtTrotter;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.solver.IterativeSolution;
import dev.nm.solver.multivariate.unconstrained.c2.steepestdescent.SteepestDescentMinimizer;
import dev.nm.solver.problem.C2OptimProblem;

public class NewtonRaphsonMinimizer
extends SteepestDescentMinimizer {
    public NewtonRaphsonMinimizer(double epsilon, int maxIterations) {
        super(epsilon, maxIterations);
    }

    @Override
    public IterativeSolution<Vector> solve(C2OptimProblem problem) throws Exception {
        return new NewtonRaphsonImpl(problem);
    }

    protected class NewtonRaphsonImpl
    extends SteepestDescentMinimizer.SteepestDescentImpl {
        @Override
        public Vector getDirection(Vector xk) {
            Object a2;
            Vector a3 = (Vector)this.problem.g().evaluate(xk);
            Matrix a4 = (Matrix)this.problem.H().evaluate(xk);
            try {
                a2 = new Inverse(a4);
            }
            catch (Exception a5) {
                try {
                    GoldfeldQuandtTrotter a6 = new GoldfeldQuandtTrotter(a4, Double.POSITIVE_INFINITY);
                    a2 = new Inverse((Matrix)a6);
                }
                catch (Exception a7) {
                    a2 = a4.ONE();
                }
            }
            Vector a8 = a2.multiply(a3);
            a8 = a8.scaled(-1.0);
            return a8;
        }

        protected NewtonRaphsonImpl(C2OptimProblem problem) throws Exception {
            super(NewtonRaphsonMinimizer.this, problem);
        }
    }
}

