/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.simplex.solver;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.qr.HouseholderQR;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LinearSystemSolver;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.GivensMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.DOKSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary.ConjugateGradientNormalErrorSolver;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.SubVectorRef;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.Basis;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.analysis.function.rn2r1.AbstractRealScalarFunction;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.algorithm.iterative.monitor.CountMonitor;
import dev.nm.misc.algorithm.iterative.tolerance.AbsoluteTolerance;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.solver.multivariate.constrained.constraint.EqualityConstraints;
import dev.nm.solver.multivariate.constrained.constraint.LessThanConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearEqualityConstraints;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.LPMinimizer;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.LPSolution;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.LPSolver;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.exception.LPInfeasible;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.exception.LPUnbounded;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.problem.LPProblem;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Duplicate member names - consider using --renamedupmembers true
 */
public class LPRevisedSimplexSolver
implements LPSolver<Problem, LPSolution<LPMinimizer>> {
    private final double if;
    private final int new = Integer.MAX_VALUE;

    private Matrix final(Vector[] a2, List<Integer> a4) {
        return MatrixFactory.rbind(a4.stream().map(a3 -> a2[a3 - 1]).collect(Collectors.toList()));
    }

    @Override
    public LPSolution<LPMinimizer> solve(Problem p) throws Exception {
        Vector a2 = this.final(p);
        double a3 = p.c().innerProduct(a2);
        return this.final(a2, a3);
    }

    private Vector do(Matrix a2, Vector a3) {
        LPRevisedSimplexSolver a4;
        SparseVector a5 = new SparseVector(a2.nRows());
        a5.set(a5.size(), -1.0);
        Vector a6 = a4.final(a2, (Vector)a5, a3);
        return a6;
    }

    private LPSolution<LPMinimizer> final(final Vector a2, final double a3) {
        LPRevisedSimplexSolver a4;
        return new LPSolution<LPMinimizer>(){

            @Override
            public LPMinimizer minimizer() {
                return new LPMinimizer(){

                    @Override
                    public double minimum() {
                        return a3;
                    }
                    {
                        1 a3;
                    }

                    @Override
                    public Vector minimizer() {
                        return a2;
                    }
                };
            }
            {
                1 a32;
            }

            @Override
            public double minimum() {
                return a3;
            }
        };
    }

    public Vector findFeasiblePoint(Matrix A2, Vector b2) throws LPUnbounded, LPInfeasible {
        Problem a2 = this.final(A2, b2);
        Vector a3 = this.char(A2, b2);
        Vector a4 = null;
        try {
            a4 = this.final(a2, a3);
        }
        catch (VertexNotFound a5) {
            a4 = this.final(a5.if, a5.new);
        }
        int a6 = A2.nCols();
        if (!DoubleUtils.isZero(a4.get(a6 + 1), this.if)) {
            throw new LPInfeasible();
        }
        SubVectorRef a7 = new SubVectorRef(a4, 1, a6);
        return a7;
    }

    private int final(int a2, Vector[] a3, Matrix a4, int a5, Set<Integer> a6, Set<Integer> a7) {
        for (int a8 : a6) {
            LPRevisedSimplexSolver a9;
            if (a7.contains(a8)) continue;
            Vector a10 = a3[a8 - 1];
            Vector a11 = a4.multiply(a10);
            SubVectorRef a12 = new SubVectorRef(a11, a5 + 1, a2);
            double a13 = a12.norm();
            if (DoubleUtils.isZero(a13, a9.if)) {
                a7.add(a8);
                continue;
            }
            return a8;
        }
        return -1;
    }

    private void final(Matrix a2, Matrix a3, int a4, int a5) {
        int a6 = a3.nCols();
        for (int a7 = 1; a7 <= a6; ++a7) {
            a2.set(a5, a7, a3.get(a4, a7));
        }
    }

    private Vector char(Matrix a2, Vector a3) {
        int a4 = a2.nCols();
        double a5 = Math.max(0.0, DoubleArrayMath.max(a3.toArray()));
        SparseVector a6 = new SparseVector(a4 + 1);
        a6.set(a4 + 1, a5);
        return a6;
    }

    private void final(Matrix a2, Vector a3, int a4) {
        Vector a5 = a2.multiply(a3);
        int a6 = a3.size();
        Vector a7 = a5;
        ArrayList<GivensMatrix> a8 = new ArrayList<GivensMatrix>(a6 - a4 - 1);
        for (int a9 = a6 - 1; a9 >= a4 + 1; --a9) {
            GivensMatrix a10 = GivensMatrix.CtorToRotateRows(a6, a9, a9 + 1, a7.get(a9), a7.get(a9 + 1));
            a7 = a10.multiplyInPlace(a7);
            a8.add(a10);
        }
        for (GivensMatrix a10 : a8) {
            a10.multiplyInPlace(a2);
        }
    }

    private Set<Integer> final(int a2, List<Integer> a4) {
        return ((Stream)IntStream.rangeClosed(1, a2).parallel().filter(a3 -> !a4.contains(a3)).boxed().sequential()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public LPSolution<LPMinimizer> solve(LPProblem p) throws Exception {
        ProblemTransformer a2 = new ProblemTransformer(p);
        Problem a3 = a2.toProblem();
        Vector a4 = this.final(a3);
        Vector a5 = a2.toGeneralLPSolution(a4);
        double a6 = p.c().innerProduct(a5);
        return this.final(a5, a6);
    }

    private Vector final(Problem a2) throws Exception {
        LPRevisedSimplexSolver a3;
        Vector a4 = a3.findFeasiblePoint(a2.new, a2.if);
        try {
            return a3.final(a2, a4);
        }
        catch (VertexNotFound a5) {
            LinearSystemSolver.Solution a6 = new LinearSystemSolver(a3.if).solve(a5.if);
            Vector a7 = a6.getHomogeneousSoln().get(0);
            if (DoubleUtils.isZero(a7.innerProduct(a2.void), a3.if)) {
                return a6.getParticularSolution(a5.new);
            }
            throw new LPUnbounded(0);
        }
    }

    private int final(Vector a2) {
        int a3 = Integer.MAX_VALUE;
        for (int a4 = 1; a4 <= a2.size(); ++a4) {
            LPRevisedSimplexSolver a5;
            if (!DoubleUtils.isNegative(a2.get(a4), a5.if) || a4 >= a3) continue;
            a3 = a4;
        }
        return a3;
    }

    private List<Integer> final(Vector a2, Function<Double, Boolean> a3) {
        ArrayList<Integer> a4 = new ArrayList<Integer>();
        for (int a5 = 1; a5 <= a2.size(); ++a5) {
            if (!a3.apply(a2.get(a5)).booleanValue()) continue;
            a4.add(a5);
        }
        return a4;
    }

    private SparseVector final(Vector a2, List<Integer> a3) {
        int a4 = a3.size();
        ArrayList<Integer> a5 = new ArrayList<Integer>(a4);
        ArrayList<Double> a6 = new ArrayList<Double>(a4);
        for (int a7 = 1; a7 <= a4; ++a7) {
            double a8 = a2.get(a3.get(a7 - 1));
            if (a8 == 0.0) continue;
            a5.add(a7);
            a6.add(a8);
        }
        SparseVector a9 = new SparseVector(a4, DoubleUtils.collection2IntArray(a5), DoubleUtils.collection2DoubleArray(a6));
        return a9;
    }

    private Vector final(Problem a2, Vector a3) throws LPUnbounded, LPInfeasible, VertexNotFound {
        LPRevisedSimplexSolver a4;
        WorkingSet a5 = a4.findVertex(a2.new, a2.if, a3);
        Vector a6 = a4.final(a2, a5.new, a5.if, (List<Integer>)a5.void);
        return a6;
    }

    private void final(List<Integer> a2, int a3, int a4) {
        a2.set(a4 - 1, a3);
    }

    private Vector final(Matrix a2, Vector a3) {
        LPRevisedSimplexSolver a4;
        Vector a5 = null;
        ConjugateGradientNormalErrorSolver a6 = new ConjugateGradientNormalErrorSolver(a2.nCols() + 1, new AbsoluteTolerance(a4.if));
        try {
            CountMonitor<Vector> a7 = new CountMonitor<Vector>();
            a5 = a6.solve(new LSProblem(a2, a3), a7).search(new Vector[]{new DenseVector(a2.nCols())});
        }
        catch (ConvergenceFailure a8) {
            a5 = new LinearSystemSolver(a4.if).solve(a2).getParticularSolution(a3);
        }
        return a5;
    }

    private List<Integer> final(int a4, Matrix a5, List<Integer> a6) {
        Vector a7 = VectorFactory.diagonal(a5);
        int[] a8 = IntStream.rangeClosed(1, a7.size()).boxed().sorted(Comparator.comparing(a3 -> -Math.abs(a7.get((int)a3)))).map(a3 -> (Integer)a6.get(a3 - 1)).limit(a4).sorted().mapToInt(a2 -> a2).toArray();
        return DoubleUtils.intArray2List(a8);
    }

    public LPRevisedSimplexSolver(double epsilon) {
        this.if = epsilon;
    }

    private boolean final(Vector a2) {
        for (int a3 = 1; a3 <= a2.size(); ++a3) {
            LPRevisedSimplexSolver a4;
            if (!DoubleUtils.isNegative(a2.get(a3), a4.if)) continue;
            return false;
        }
        return true;
    }

    public WorkingSet findVertex(Matrix A2, Vector b2, Vector x0) throws LPInfeasible, VertexNotFound {
        Object a3;
        Object a4;
        int a5 = A2.nRows();
        int a6 = A2.nCols();
        Vector[] a7 = MatrixUtils.toRows(A2);
        Vector a8 = x0;
        Vector a9 = A2.multiply(a8).minus(b2);
        if (!this.final(a9)) {
            throw new LPInfeasible();
        }
        List<Integer> a10 = this.final(a9, (Double a2) -> {
            LPRevisedSimplexSolver a3;
            return DoubleUtils.isZero(a2, a3.if);
        });
        if (a10.size() > a6) {
            a10 = a10.stream().limit(a6).collect(Collectors.toList());
        }
        Matrix a11 = null;
        Matrix a12 = null;
        int a13 = 0;
        if (!a10.isEmpty()) {
            a11 = this.final(a7, a10);
            a4 = a11.t();
            a3 = new HouseholderQR((Matrix)a4, this.if);
            a13 = ((HouseholderQR)a3).rank();
            if (a10.size() > a13) {
                a10 = this.final(a13, ((HouseholderQR)a3).R(), a10);
                a11 = this.final(a7, a10);
                a4 = a11.t();
                a3 = new HouseholderQR((Matrix)a4, this.if);
            }
        } else {
            throw new RuntimeException("no initial working set");
        }
        a12 = ((HouseholderQR)a3).squareQ().t();
        a4 = this.final(a5, a10);
        a3 = new HashSet();
        Vector a14 = new SparseVector(a6);
        while (a13 < a6) {
            int a15 = this.final(a6, a7, a12, a13, (Set<Integer>)a4, (Set<Integer>)a3);
            if (a15 == -1) {
                a11 = this.final(a7, a10);
                throw new VertexNotFound(a11, this.final(b2, a10));
            }
            ArrayList<Integer> a16 = new ArrayList<Integer>(a10);
            a16.add(a15);
            Matrix a17 = this.final(a7, a16);
            a14 = this.do(a17, a14);
            Optional<AbstractMap.SimpleImmutableEntry<Integer, Double>> a18 = this.final((Set<Integer>)a4, a7, a8, b2, a14);
            int a19 = 0;
            double a20 = Double.NaN;
            if (a18.isPresent()) {
                a19 = a18.get().getKey();
                a20 = a18.get().getValue();
            }
            if (a19 != 0) {
                a10.add(a19);
                a4.remove(a19);
                a8 = a8.add(a14.scaled(a20));
                this.final(a12, a7[a19 - 1], a10.size() - 1);
                ++a13;
                continue;
            }
            throw new RuntimeException("no alpha found");
        }
        a11 = this.final(a7, a10);
        return new WorkingSet(a8, a11, a10);
    }

    private Vector final(Matrix a2, Vector a3, Vector a4) {
        LPRevisedSimplexSolver a5;
        a2 = new CSRSparseMatrix(a2);
        Vector a6 = null;
        ConjugateGradientNormalErrorSolver a7 = new ConjugateGradientNormalErrorSolver(a2.nCols() + 1, new AbsoluteTolerance(a5.if));
        try {
            CountMonitor<Vector> a8 = new CountMonitor<Vector>();
            a6 = a7.solve(new LSProblem(a2, a3), a8).search(a4);
        }
        catch (ConvergenceFailure a9) {
            a6 = new LinearSystemSolver(a5.if).solve(a2).getParticularSolution(a3);
        }
        return a6;
    }

    private EnteringIndex final(Vector a2, Matrix a3, Vector a4, List<Integer> a5) throws LPUnbounded {
        int a6 = 0;
        double a7 = Double.POSITIVE_INFINITY;
        for (int a8 = 1; a8 <= a2.size(); ++a8) {
            double a9;
            LPRevisedSimplexSolver a10;
            double a11;
            if (a5.contains(a8) || !DoubleUtils.isNegative(a11 = a3.getRow(a8).innerProduct(a4), a10.if) || DoubleUtils.compare(a9 = a2.get(a8) / -a11, a7, a10.if) > 0) continue;
            if (DoubleUtils.compare(a9, a7, a10.if) < 0) {
                a7 = a9;
                a6 = a8;
                continue;
            }
            if (a8 >= a6) continue;
            a6 = a8;
        }
        if (a6 == 0) {
            throw new LPUnbounded(0);
        }
        return new EnteringIndex(a6, a7);
    }

    private Optional<AbstractMap.SimpleImmutableEntry<Integer, Double>> final(Set<Integer> a3, Vector[] a4, Vector a5, Vector a7, Vector a8) {
        LPRevisedSimplexSolver a9;
        return a3.parallelStream().map(a6 -> {
            LPRevisedSimplexSolver a7;
            Vector a8 = a4[a6 - 1];
            double a9 = a8.innerProduct(a8);
            if (!DoubleUtils.isNegative(a9, a7.if)) {
                return new AbstractMap.SimpleImmutableEntry<Integer, Double>((Integer)a6, Double.NaN);
            }
            double a10 = (a8.innerProduct(a5) - a7.get((int)a6)) / -a9;
            return new AbstractMap.SimpleImmutableEntry<Integer, Double>((Integer)a6, a10);
        }).filter(a2 -> !((Double)a2.getValue()).isNaN()).min(Comparator.comparingDouble(a2 -> (Double)a2.getValue()));
    }

    private Problem final(Matrix a2, Vector a3) {
        int a4 = a2.nCols();
        int a5 = a3.size();
        SparseVector a6 = new SparseVector(a4 + 1);
        a6.set(a4 + 1, 1.0);
        SparseMatrix a7 = new DOKSparseMatrix(a5 + 1, a4 + 1);
        MatrixFactory.replaceInPlace(a7, 1, a5, 1, a4, a2);
        for (int a8 = 1; a8 <= a5 + 1; ++a8) {
            a7.set(a8, a4 + 1, 1.0);
        }
        a7 = new CSRSparseMatrix(a7);
        SparseVector a9 = new SparseVector(a5 + 1);
        for (int a10 = 1; a10 <= a5; ++a10) {
            a9.set(a10, a3.get(a10));
        }
        return new Problem(a7, a9, a6);
    }

    private Vector final(Problem a2, Vector a3, Matrix a4, List<Integer> a5) throws LPUnbounded, LPInfeasible {
        int a6 = a2.void.size();
        Vector a7 = a3;
        for (int a8 = 0; a8 < Integer.MAX_VALUE; ++a8) {
            LPRevisedSimplexSolver a9;
            Vector a10 = a9.final(a4.t(), a2.void);
            if (a9.final(a10)) {
                return a7;
            }
            int a11 = a9.final(a10);
            Vector a12 = a9.final(a4, (Vector)new Basis(a6, a11));
            Vector a13 = a2.new.multiply(a7).minus(a2.if);
            EnteringIndex a14 = a9.final(a13, a2.new, a12, a5);
            a7 = a7.add(a12.scaled(a14.new));
            a9.final(a4, a2.new, a14.if, a11);
            a9.final(a5, a14.if, a11);
        }
        throw new LPInfeasible();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class VertexNotFound
    extends Exception {
        private final Matrix if;
        private final Vector new;

        VertexNotFound(Matrix a2, Vector a3) {
            VertexNotFound a4;
            a4.if = a2;
            a4.new = a3;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class ProblemTransformer {
        private final LPProblem if;
        private final int[] new;

        public Problem toProblem() {
            Matrix a2 = this.final(this.if.A());
            Vector a3 = this.final(this.if.b());
            Matrix a4 = this.final(this.if.Aeq());
            Vector a5 = this.final(this.if.beq());
            Vector a6 = this.final(this.if.c());
            ArgumentAssertion.assertTrue(a2 != null || a4 != null, "both greater-than-or-equal-to and equality constraints are null", new Object[0]);
            Matrix a7 = a2;
            Matrix a8 = a4 == null ? null : MatrixFactory.rbind(a4, a4.opposite());
            Matrix a9 = this.final();
            Matrix a10 = MatrixFactory.rbind(a7, a8, a9);
            Vector a11 = a3;
            Vector a12 = a5 == null ? null : VectorFactory.concat(new Vector[]{a5, a5.opposite()});
            SparseVector a13 = a9 == null ? null : new SparseVector(a9.nRows());
            Vector a14 = VectorFactory.concat(a11, a12, a13);
            Vector a15 = a6;
            return new Problem(a10, a14, a15);
        }

        private Vector final(Vector a2) {
            if (a2 == null) {
                return null;
            }
            return new SparseVector(a2);
        }

        public ProblemTransformer(LPProblem problem) {
            this.if = problem;
            this.new = IntStream.rangeClosed(1, problem.dimension()).filter(a3 -> problem.isFree(a3)).toArray();
        }

        private Matrix final() {
            ProblemTransformer a3;
            int a4 = a3.if.dimension();
            if (a3.new.length == a4) {
                return null;
            }
            int[] a5 = IntStream.rangeClosed(1, a4).filter(a2 -> {
                ProblemTransformer a3;
                return !a3.if.isFree(a2);
            }).toArray();
            CSRSparseMatrix a6 = new CSRSparseMatrix(a4 - a3.new.length, a4);
            for (int a7 = 0; a7 < a5.length; ++a7) {
                a6.set(a7 + 1, a5[a7], 1.0);
            }
            return a6;
        }

        private Matrix final(Matrix a2) {
            if (a2 == null) {
                return null;
            }
            return new CSRSparseMatrix(a2);
        }

        public Vector toGeneralLPSolution(Vector solution) {
            return solution;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Problem
    implements LPProblem {
        private final Vector void;
        private final Vector if;
        private final Matrix new;

        @Override
        public RealScalarFunction f() {
            return new AbstractRealScalarFunction(this.void.size()){

                @Override
                public Double evaluate(Vector x) {
                    return void.innerProduct(x);
                }
                {
                    1 a4;
                    super(a3);
                }
            };
        }

        @Override
        public ImmutableVector c() {
            return new ImmutableVector(this.void);
        }

        @Override
        public LessThanConstraints getLessThanConstraints() {
            return null;
        }

        @Override
        public ImmutableVector b() {
            return null;
        }

        @Override
        public ImmutableMatrix Aeq() {
            return new ImmutableMatrix(this.new);
        }

        @Override
        public int dimension() {
            return this.void.size();
        }

        public Problem(Matrix A2, Vector b2, Vector c2) {
            this.new = A2;
            this.if = b2;
            this.void = c2;
        }

        @Override
        public ImmutableMatrix A() {
            return null;
        }

        @Override
        public ImmutableVector beq() {
            return new ImmutableVector(this.if);
        }

        @Override
        public boolean isFree(int i2) {
            return false;
        }

        @Override
        public EqualityConstraints getEqualityConstraints() {
            return new LinearEqualityConstraints(this.new, this.if);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class WorkingSet {
        private final List<Integer> void;
        private final Matrix if;
        private final Vector new;

        private WorkingSet(Vector a2, Matrix a3, List<Integer> a4) {
            WorkingSet a5;
            a5.new = a2;
            a5.if = a3;
            a5.void = a4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class EnteringIndex {
        private final int if;
        private final double new;

        private EnteringIndex(int a2, double a3) {
            EnteringIndex a4;
            a4.if = a2;
            a4.new = a3;
        }
    }
}

