/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.constrained.constraint.linear;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.solver.multivariate.constrained.constraint.EqualityConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearConstraints;

public class LinearEqualityConstraints
extends LinearConstraints
implements EqualityConstraints {
    public LinearEqualityConstraints(Matrix A2, Vector b2) {
        super(A2, b2);
        ArgumentAssertion.assertTrue(this.size() < this.dimension(), "the number of equality constraints must be less than the number of variables", new Object[0]);
    }

    @Deprecated
    public LinearEqualityConstraints getReducedLinearEqualityConstraints() {
        if (!this.isReducible()) {
            return this;
        }
        int a2 = MatrixMeasure.rank(this.A());
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isReducible() {
        int a2 = this.size();
        Matrix a3 = MatrixFactory.cbind(this.A(), new DenseMatrix(this.b()));
        int a4 = MatrixMeasure.rank(this.A());
        if (a4 >= a2) {
            return false;
        }
        int a5 = MatrixMeasure.rank(a3);
        return a5 == a4;
    }
}

