/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.number.big;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;
import dev.nm.misc.license.Package;
import java.math.BigDecimal;
import java.math.MathContext;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BigDecimalUtils {
    public static final BigDecimal PI;

    static {
        Package.validate("NMDEV_BASIC");
        PI = new BigDecimal("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679");
    }

    public static BigDecimal log(BigDecimal x) {
        return BigDecimalUtils.log(x, Constants.MACH_SCALE);
    }

    public static BigDecimal exp(BigDecimal x, int scale) {
        int a2 = BigDecimalUtils.getWhole(x).intValue();
        BigDecimal a3 = BigDecimalUtils.getFractional(x);
        BigDecimal a4 = BigDecimalUtils.char(BigDecimal.ONE, scale);
        BigDecimal a5 = BigDecimalUtils.pow(a4, a2, scale);
        BigDecimal a6 = BigDecimalUtils.char(a3, scale);
        BigDecimal a7 = a5.multiply(a6);
        return a7.setScale(scale, 6);
    }

    public static BigDecimal log(BigDecimal x, int scale) {
        BigDecimal a2;
        if (x.compareTo(BigDecimal.TEN) < 0) {
            a2 = BigDecimalUtils.final(x, scale);
        } else {
            int a3 = x.precision() - x.scale() - 1;
            BigDecimal a4 = BigDecimal.valueOf(10L).pow(a3);
            BigDecimal a5 = x.divide(a4);
            BigDecimal a6 = BigDecimalUtils.final(BigDecimal.valueOf(10L), scale);
            BigDecimal a7 = BigDecimalUtils.final(a5, scale);
            a2 = BigDecimal.valueOf(a3).multiply(a6).add(a7);
        }
        return a2.setScale(scale, 6);
    }

    private BigDecimalUtils() {
        BigDecimalUtils a2;
    }

    public static BigDecimal exp(double x) {
        return BigDecimalUtils.exp(x, Constants.MACH_SCALE);
    }

    public static BigDecimal pow(BigDecimal a2, int n) {
        return BigDecimalUtils.pow(a2, n, Constants.MACH_SCALE);
    }

    public static boolean equals(BigDecimal n1, BigDecimal n2, int precision) {
        return BigDecimalUtils.compare(n1, n2, precision) == 0;
    }

    public static BigDecimal sum(double ... big) {
        BigDecimal a2 = BigDecimal.ZERO;
        for (double a3 : big) {
            a2 = a2.add(BigDecimal.valueOf(a3));
        }
        return a2;
    }

    public static BigDecimal pow(BigDecimal a2, BigDecimal b2) {
        return BigDecimalUtils.pow(a2, b2, Constants.MACH_SCALE);
    }

    public static BigDecimal sum(BigDecimal ... big) {
        BigDecimal a2 = BigDecimal.ZERO;
        for (BigDecimal a3 : big) {
            a2 = a2.add(a3);
        }
        return a2;
    }

    public static BigDecimal getFractional(BigDecimal num) {
        BigDecimal a2 = num.subtract(BigDecimalUtils.getWhole(num));
        return a2;
    }

    public static BigDecimal exp(BigDecimal x) {
        return BigDecimalUtils.exp(x, Constants.MACH_SCALE);
    }

    public static BigDecimal pow(BigDecimal a2, BigDecimal b2, int scale) {
        BigDecimal a3 = b2;
        a3 = a3.multiply(BigDecimalUtils.log(a2, scale));
        a3 = BigDecimalUtils.exp(a3, scale);
        return a3;
    }

    private static BigDecimal char(BigDecimal a2, int a3) {
        MathContext a4 = new MathContext(a3);
        BigDecimal a5 = BigDecimal.ZERO;
        BigDecimal a6 = BigDecimal.ONE;
        BigDecimal a7 = new BigDecimal(1, a4);
        int a8 = 1;
        while (!BigDecimalUtils.equals(a5, a6, a3)) {
            a5 = a6;
            a7 = a7.multiply(a2, a4);
            a7 = a7.divide(BigDecimal.valueOf(a8), a3 + 1, 6);
            a6 = a5.add(a7);
            ++a8;
        }
        return a5.setScale(a3, 6);
    }

    public static BigDecimal exp(double x, int scale) {
        return BigDecimalUtils.exp(BigDecimal.valueOf(x), scale);
    }

    public static int compare(BigDecimal n1, BigDecimal n2, int p) {
        BigDecimal a2 = BigDecimal.ONE.movePointLeft(p);
        BigDecimal a3 = n1.subtract(n2).abs();
        int a4 = a3.compareTo(a2);
        return a4 <= 0 ? 0 : n1.compareTo(n2);
    }

    private static BigDecimal final(BigDecimal a2, int a3) {
        ArgumentAssertion.assertPositive(a2.signum(), "x");
        int a4 = 2 * a3;
        BigDecimal a5 = a2;
        if (a5.compareTo(BigDecimal.valueOf(10L)) == 0) {
            a5 = BigDecimal.valueOf(2.302585092994);
        } else if (a5.compareTo(BigDecimal.valueOf(1L)) == 0) {
            a5 = BigDecimal.ZERO;
        }
        BigDecimal a6 = BigDecimal.ONE;
        while (!BigDecimalUtils.equals(a6, BigDecimal.ZERO, a3)) {
            BigDecimal a7 = BigDecimalUtils.exp(a5, a4);
            a6 = BigDecimal.ONE.subtract(a2.divide(a7, a4, 6));
            a5 = a5.subtract(a6);
        }
        return a5.setScale(a3, 6);
    }

    public static BigDecimal pow(BigDecimal a2, int n, int scale) {
        if (n < 0) {
            return BigDecimal.ONE.divide(BigDecimalUtils.pow(a2, -n, scale), scale, 6);
        }
        return a2.pow(n).setScale(scale, 6);
    }

    public static BigDecimal getWhole(BigDecimal num) {
        BigDecimal a2 = num.setScale(0, 1);
        return a2;
    }
}

