/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.function.special.gamma;

import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.special.gamma.Gamma;
import dev.nm.analysis.function.special.gamma.GammaLanczosQuick;
import dev.nm.analysis.function.special.gamma.Lanczos;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GammaLanczos
extends AbstractUnivariateRealFunction
implements Gamma {
    private final Lanczos new;

    public GammaLanczos(double g2, int n, int scale) {
        this.new = new Lanczos(g2, n, scale);
    }

    @Override
    public double evaluate(double x) {
        if (DoubleUtils.isZero(x, 0.0)) {
            return Double.POSITIVE_INFINITY;
        }
        double a2 = x > 0.0 ? x : -x;
        double a3 = this.new.logGamma(a2);
        a3 = Math.exp(a3);
        a3 = x > 0.0 ? a3 : GammaLanczosQuick.reflectionFormula(-x, a3);
        return a3;
    }

    public GammaLanczos() {
        this.new = new Lanczos();
    }
}

