/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.function.rn2r1;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.analysis.function.rn2r1.AbstractRealScalarFunction;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QuadraticFunction
extends AbstractRealScalarFunction {
    private final ImmutableVector void;
    private final ImmutableMatrix if;
    private final double new;

    public QuadraticFunction(Matrix H2, Vector p) {
        this(H2, p, 0.0);
    }

    public ImmutableMatrix Hessian() {
        return this.if;
    }

    public ImmutableVector p() {
        return this.void;
    }

    public QuadraticFunction(Matrix H2, Vector p, double c2) {
        super(p.size());
        this.if = new ImmutableMatrix(H2);
        this.void = new ImmutableVector(p);
        this.new = c2;
    }

    public String toString() {
        return String.format("1/2 * x'%sx + x'%s", this.if, this.void);
    }

    public QuadraticFunction(QuadraticFunction f2) {
        this(f2.if, f2.void, f2.new);
    }

    @Override
    public Double evaluate(Vector z) {
        DenseMatrix a2 = new DenseMatrix(z);
        Matrix a3 = a2.t();
        Matrix a4 = a3.multiply(this.if).multiply(a2);
        Vector a5 = a3.multiply(this.void);
        double a6 = 0.5 * a4.get(1, 1) + a5.get(1) + this.new;
        return a6;
    }
}

