/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.function.polynomial;

import dev.nm.algebra.structure.Ring;
import dev.nm.algebra.structure.VectorSpace;
import dev.nm.analysis.function.polynomial.HornerScheme;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.number.DoubleUtils;
import dev.nm.number.Real;
import dev.nm.number.complex.Complex;
import dev.nm.number.complex.ElementaryFunction;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Polynomial
extends AbstractUnivariateRealFunction
implements Ring<Polynomial>,
VectorSpace<Polynomial, Real> {
    private final double[] if;
    public static final Polynomial ZERO = new Polynomial(0.0);
    private int new;
    public static final Polynomial ONE = new Polynomial(1.0);

    @Override
    public Complex evaluate(Number x) {
        if (x instanceof Complex) {
            return this.evaluate((Complex)x);
        }
        double a2 = this.evaluate(x.doubleValue());
        return new Complex(a2, 0.0);
    }

    public int degree() {
        return this.new;
    }

    @Override
    public Polynomial add(Polynomial that) {
        double[] a2;
        double[] a3;
        if (this.new > that.new) {
            a3 = this.if;
            a2 = that.if;
        } else {
            a3 = that.if;
            a2 = this.if;
        }
        int a4 = a3.length - a2.length;
        double[] a5 = new double[a3.length];
        System.arraycopy(a3, 0, a5, 0, a4);
        for (int a6 = 0; a6 < a2.length; ++a6) {
            a5[a4 + a6] = a3[a4 + a6] + a2[a6];
        }
        return new Polynomial(a5);
    }

    public double[] getCoefficients() {
        return Arrays.copyOf(this.if, this.if.length);
    }

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        for (int a3 = 0; a3 <= this.new; ++a3) {
            if (this.if[a3] == 0.0) continue;
            if (a3 > 0 && this.if[a3] >= 0.0) {
                a2.append("+");
            }
            a2.append(String.format("%.2f", this.if[a3]));
            if (a3 == this.new) continue;
            a2.append(String.format("(x^%d)", this.new - a3));
        }
        return a2.toString();
    }

    @Override
    public Polynomial ZERO() {
        return ZERO;
    }

    @Override
    public Polynomial scaled(Real c2) {
        return this.scaled(c2.doubleValue());
    }

    @Override
    public Polynomial scaled(double c2) {
        double[] a2 = new double[this.if.length];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = c2 * this.if[a3];
        }
        return new Polynomial(a2);
    }

    public Polynomial(double ... coefficients) {
        this.new = coefficients.length - 1;
        for (int a2 = 0; a2 < coefficients.length - 1 && coefficients[a2] == 0.0; ++a2) {
            --this.new;
        }
        this.if = Arrays.copyOfRange(coefficients, coefficients.length - this.new - 1, coefficients.length);
    }

    public double getCoefficient(int i2) {
        if (i2 < 0) {
            throw new IllegalArgumentException("coefficient index counts from 0, the highest order term");
        }
        return i2 < this.if.length ? this.if[i2] : 0.0;
    }

    @Override
    public Polynomial minus(Polynomial that) {
        return this.add((Polynomial)that.opposite());
    }

    @Override
    public Polynomial ONE() {
        return ONE;
    }

    @Override
    public double evaluate(double x) {
        if (this.new == 0) {
            return this.if[0];
        }
        HornerScheme a2 = new HornerScheme(this, x);
        return a2.remainder();
    }

    public Polynomial(Polynomial that) {
        this(that.getCoefficients());
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 71 * a2 + this.new;
        a2 = 71 * a2 + (this.if != null ? this.if.hashCode() : 0);
        return a2;
    }

    @Override
    public Complex evaluate(Complex z) {
        Object a2 = z.ZERO();
        for (int a3 = 0; a3 <= this.new; ++a3) {
            a2 = ((Complex)a2).add(ElementaryFunction.pow(z, new Complex(this.new - a3, 0.0)).multiply(new Complex(this.if[a3], 0.0)));
        }
        return a2;
    }

    @Override
    public Polynomial opposite() {
        double[] a2 = new double[this.if.length];
        for (int a3 = 0; a3 <= this.new; ++a3) {
            a2[a3] = -this.if[a3];
        }
        return new Polynomial(a2);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Polynomial)) {
            return false;
        }
        Polynomial a2 = (Polynomial)obj;
        if (this.new != a2.new) {
            return false;
        }
        return this.if == a2.if || this.if != null && DoubleUtils.equal(this.if, a2.if, 0.0);
    }

    public Polynomial pow(int n) {
        Polynomial a2 = new Polynomial(this);
        for (int a3 = 2; a3 <= n; ++a3) {
            a2 = a2.multiply(this);
        }
        return a2;
    }

    public Polynomial getNormalization() {
        double[] a2 = Arrays.copyOf(this.if, this.if.length);
        double a3 = a2[0];
        int a4 = 1;
        while (a4 < a2.length) {
            int n = a4++;
            a2[n] = a2[n] / a3;
        }
        a2[0] = 1.0;
        return new Polynomial(a2);
    }

    @Override
    public Polynomial multiply(Polynomial that) {
        int a2 = this.new + that.new;
        double[] a3 = new double[a2 + 1];
        for (int a4 = 0; a4 < a3.length; ++a4) {
            a3[a4] = 0.0;
            for (int a5 = 0; a5 <= a4; ++a5) {
                int n = a4;
                a3[n] = a3[n] + that.getCoefficient(a5) * this.getCoefficient(a4 - a5);
            }
        }
        return new Polynomial(a3);
    }
}

