/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentiation.univariate;

import dev.nm.analysis.function.FunctionOps;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FiniteDifference
extends AbstractUnivariateRealFunction {
    private final Type void;
    private final int if;
    private final UnivariateRealFunction new;

    public double df(double x, double h2) {
        double a2 = 0.0;
        int a3 = 1;
        for (int a4 = 0; a4 <= this.if; ++a4) {
            double a5 = x;
            switch (this.void) {
                case FORWARD: {
                    a5 += (double)(this.if - a4) * h2;
                    break;
                }
                case BACKWARD: {
                    a5 += (double)(-a4) * h2;
                    break;
                }
                case CENTRAL: {
                    a5 += ((double)this.if / 2.0 - (double)a4) * h2;
                }
            }
            a2 += (double)a3 * FunctionOps.combination(this.if, a4) * this.new.evaluate(a5);
            a3 *= -1;
        }
        return a2;
    }

    @Override
    public double evaluate(double x) {
        double a2 = Math.pow(Constants.MACH_EPS, 1.0 / (double)(this.if + 1)) * Math.max(0.1, Math.abs(x));
        return this.evaluate(x, a2);
    }

    public double evaluate(double x, double h2) {
        h2 = new PracticalFix().get(x, h2);
        double a2 = this.df(x, h2);
        if (this.if % 2 == 1 && this.void == Type.CENTRAL) {
            a2 = 0.5 * (this.df(x - h2 / 2.0, h2) + this.df(x + h2 / 2.0, h2));
        }
        double a3 = a2 / Math.pow(h2, this.if);
        return a3;
    }

    public FiniteDifference(UnivariateRealFunction f2, int order, Type type) {
        ArgumentAssertion.assertPositive(order, "the order of derivative");
        this.if = order;
        this.void = type;
        this.new = f2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class PracticalFix {
        private volatile double new;

        double get(double a2, double a3) {
            PracticalFix a4;
            a4.new = a2 + a3;
            a3 = a4.new - a2;
            return a3;
        }

        private PracticalFix() {
            PracticalFix a2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Type {
        FORWARD,
        BACKWARD,
        CENTRAL;


        private Type() {
            Type a2;
        }
    }
}

