/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentiation.univariate;

import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.differentiation.Ridders;
import dev.nm.analysis.differentiation.univariate.DBetaRegularized;
import dev.nm.analysis.differentiation.univariate.DErf;
import dev.nm.analysis.differentiation.univariate.DGamma;
import dev.nm.analysis.differentiation.univariate.DGaussian;
import dev.nm.analysis.differentiation.univariate.DPolynomial;
import dev.nm.analysis.differentiation.univariate.FiniteDifference;
import dev.nm.analysis.function.polynomial.Polynomial;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.function.special.beta.BetaRegularized;
import dev.nm.analysis.function.special.gamma.Digamma;
import dev.nm.analysis.function.special.gamma.Gamma;
import dev.nm.analysis.function.special.gamma.LogGamma;
import dev.nm.analysis.function.special.gaussian.Erf;
import dev.nm.analysis.function.special.gaussian.Gaussian;
import dev.nm.analysis.function.special.gaussian.StandardCumulativeNormal;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Dfdx
extends AbstractUnivariateRealFunction {
    private final UnivariateRealFunction new;

    public Dfdx(UnivariateRealFunction f2) {
        this(f2, Method.FINITE_DIFFERENCE);
    }

    @Override
    public double evaluate(double x) {
        return this.new.evaluate(x);
    }

    public Dfdx(final UnivariateRealFunction f2, Method method) {
        if (f2 instanceof Polynomial) {
            this.new = new DPolynomial((Polynomial)f2);
        } else if (f2 instanceof BetaRegularized) {
            this.new = new DBetaRegularized(((BetaRegularized)f2).p(), ((BetaRegularized)f2).q());
        } else if (f2 instanceof LogGamma) {
            this.new = new Digamma();
        } else if (f2 instanceof Gamma) {
            this.new = new DGamma();
        } else if (f2 instanceof StandardCumulativeNormal) {
            this.new = new Gaussian();
        } else if (f2 instanceof Gaussian) {
            this.new = new DGaussian((Gaussian)f2);
        } else if (f2 instanceof Erf) {
            this.new = new DErf();
        } else {
            switch (method) {
                case RIDDERS: {
                    this.new = new AbstractUnivariateRealFunction(){
                        private final RealScalarFunction new;

                        @Override
                        public double evaluate(double x) {
                            return (Double)this.new.evaluate(new DenseVector(x));
                        }
                        {
                            1 a3;
                            a3.new = new Ridders(a3.f2, 1);
                        }
                    };
                    break;
                }
                default: {
                    this.new = new FiniteDifference(f2, 1, FiniteDifference.Type.CENTRAL);
                }
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Method {
        FINITE_DIFFERENCE,
        RIDDERS;


        private Method() {
            Method a2;
        }
    }
}

