/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.curvefit.interpolation.univariate;

import dev.nm.analysis.curvefit.interpolation.univariate.Interpolation;
import dev.nm.analysis.curvefit.interpolation.univariate.PairLookup;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.function.tuple.OrderedPairs;
import dev.nm.analysis.function.tuple.Pair;
import dev.nm.analysis.function.tuple.SortedOrderedPairs;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CubicHermite
implements Interpolation {
    private final Tangent new;

    static {
        Package.validate("NMDEV_BASIC");
    }

    public CubicHermite(Tangent tangent) {
        this.new = tangent;
    }

    @Override
    public UnivariateRealFunction fit(final OrderedPairs op) {
        return new AbstractUnivariateRealFunction(){
            private final PairLookup if;
            private final SortedOrderedPairs new;
            {
                1 a3;
                a3.new = new SortedOrderedPairs(a3.op);
                a3.if = new PairLookup(a3.new);
            }

            @Override
            public double evaluate(double x) {
                ArgumentAssertion.assertRange(x, this.if.first().x(), this.if.last().x(), "x");
                int a2 = this.if.getFloorIndex(x);
                if (a2 == this.if.size() - 1) {
                    return this.if.last().y();
                }
                Pair a3 = this.if.get(a2);
                Pair a4 = this.if.get(a2 + 1);
                double a5 = a3.x();
                double a6 = a4.x();
                double a7 = (x - a5) / (a6 - a5);
                double a8 = a3.y();
                double a9 = a4.y();
                double a10 = CubicHermite.this.new.tangentAt(this.new, a2);
                double a11 = CubicHermite.this.new.tangentAt(this.new, a2 + 1);
                double a12 = CubicHermite.this.final(a7) * a8;
                double a13 = CubicHermite.this.do(a7) * (a6 - a5) * a10;
                double a14 = CubicHermite.this.break(a7) * a9;
                double a15 = CubicHermite.this.char(a7) * (a6 - a5) * a11;
                return a12 + a13 + a14 + a15;
            }
        };
    }

    private double break(double a2) {
        return -2.0 * a2 * a2 * a2 + 3.0 * a2 * a2;
    }

    public CubicHermite() {
        this(Tangents.CATMULL_ROM);
    }

    private double do(double a2) {
        return a2 * a2 * a2 - 2.0 * a2 * a2 + a2;
    }

    private double char(double a2) {
        return a2 * a2 * a2 - a2 * a2;
    }

    private double final(double a2) {
        return 2.0 * a2 * a2 * a2 - 3.0 * a2 * a2 + 1.0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Tangents implements Tangent
    {
        CATMULL_ROM{

            @Override
            public double tangentAt(SortedOrderedPairs pairs, int k2) {
                int a2 = pairs.size();
                int a3 = Math.min(a2 - 1, k2 + 1);
                int a4 = Math.max(0, k2 - 1);
                Pair a5 = pairs.get(a3);
                Pair a6 = pairs.get(a4);
                return (a5.y() - a6.y()) / (a5.x() - a6.x());
            }
            {
                1 a2;
            }
        }
        ,
        FINITE_DIFFERENCE{
            {
                2 a2;
            }

            @Override
            public double tangentAt(SortedOrderedPairs pairs, int k2) {
                int a2 = pairs.size();
                ArgumentAssertion.assertRange(k2, 0, a2 - 1, "k");
                if (k2 == 0) {
                    Pair a3 = pairs.get(0);
                    Pair a4 = pairs.get(1);
                    double a5 = (a4.y() - a3.y()) / (a4.x() - a3.x());
                    return a5;
                }
                if (k2 == a2 - 1) {
                    Pair a6 = pairs.get(a2 - 2);
                    Pair a7 = pairs.get(a2 - 1);
                    double a8 = (a7.y() - a6.y()) / (a7.x() - a6.x());
                    return a8;
                }
                Pair a9 = pairs.get(k2 - 1);
                Pair a10 = pairs.get(k2);
                Pair a11 = pairs.get(k2 + 1);
                double a12 = (a11.y() - a10.y()) / (a11.x() - a10.x());
                double a13 = (a10.y() - a9.y()) / (a10.x() - a9.x());
                return (a12 + a13) / 2.0;
            }
        };


        private Tangents() {
            Tangents a2;
        }
    }

    public static interface Tangent {
        public double tangentAt(SortedOrderedPairs var1, int var2);
    }
}

