/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.curvefit.interpolation;

import dev.nm.analysis.curvefit.interpolation.OnlineInterpolator;
import dev.nm.analysis.function.FunctionOps;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.StepFunction;
import dev.nm.analysis.function.tuple.OrderedPairs;
import dev.nm.analysis.function.tuple.PartialFunction;
import dev.nm.misc.license.Package;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LinearInterpolator
extends AbstractUnivariateRealFunction
implements OnlineInterpolator {
    private double[] if;
    private double[] new;

    static {
        Package.validate("NMDEV_BASIC");
    }

    @Override
    public double evaluate(double u) {
        if (u < this.new[0]) {
            throw new RuntimeException(String.format("cannot interpolate smaller than %f", this.new[0]));
        }
        if (u > this.new[this.new.length - 1]) {
            throw new RuntimeException(String.format("cannot interpolate bigger than %f", this.new[this.new.length - 1]));
        }
        int a2 = Arrays.binarySearch(this.new, u);
        if (a2 >= 0) {
            return this.if[a2];
        }
        int a3 = -(a2 + 1);
        if (a3 == this.new.length - 1) {
            --a3;
        }
        int a4 = a3 + 1;
        double a5 = FunctionOps.linearInterpolate(u, this.new[a3], this.if[a3], this.new[a4], this.if[a4]);
        return a5;
    }

    @Override
    public void addData(OrderedPairs f2) {
        StepFunction a2 = new StepFunction(new PartialFunction(this.new, this.if));
        a2.add(f2);
        this.new = a2.x();
        this.if = a2.y();
    }

    public LinearInterpolator(OrderedPairs f2) {
        this.new = f2.x();
        this.if = f2.y();
    }
}

