/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.generic.matrixtype;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.generic.GenericMatrix;
import dev.nm.algebra.structure.Field;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.datastructure.Table;
import java.lang.reflect.Array;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GenericFieldMatrix<F extends Field<F>>
implements GenericMatrix<GenericFieldMatrix<F>, F> {
    private final F false;
    private final int void;
    private F[][] if;
    private final int new;

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append(String.format("%dx%d\n", this.new, this.void));
        a3.append("\t");
        for (a2 = 1; a2 <= this.void; ++a2) {
            a3.append(String.format("[,%d] ", a2));
        }
        a3.append("\n");
        for (a2 = 1; a2 <= this.new; ++a2) {
            a3.append(String.format("[%d,] ", a2));
            for (int a4 = 1; a4 <= this.void; ++a4) {
                a3.append(String.format("%s, ", this.get(a2, a4).toString()));
            }
            a3.append("\n");
        }
        return a3.toString();
    }

    @Override
    public GenericFieldMatrix<F> ONE() {
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.new, this.void, (Field)this.false.ZERO());
        for (int a3 = 0; a3 < this.new; ++a3) {
            a2.if[a3][a3] = (Field)this.false.ONE();
        }
        return a2;
    }

    @Override
    public GenericFieldMatrix<F> ZERO() {
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.new, this.void, (Field)this.false.ZERO());
        return a2;
    }

    @Override
    public int nRows() {
        return this.new;
    }

    public GenericFieldMatrix(int nRows, int nCols, F init) {
        this.new = nRows;
        this.void = nCols;
        this.false = init;
        this.if = (Field[][])Array.newInstance(init.getClass(), nRows, nCols);
        for (int a2 = 0; a2 < nRows; ++a2) {
            for (int a3 = 0; a3 < nCols; ++a3) {
                this.if[a2][a3] = init;
            }
        }
    }

    @Override
    public GenericFieldMatrix<F> add(GenericFieldMatrix<F> that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.new, this.void, (Field)this.false.ZERO());
        for (int a3 = 0; a3 < this.new; ++a3) {
            for (int a4 = 0; a4 < this.void; ++a4) {
                a2.if[a3][a4] = (Field)this.if[a3][a4].add(that.if[a3][a4]);
            }
        }
        return a2;
    }

    @Override
    public int nCols() {
        return this.void;
    }

    @Override
    public F get(int row, int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        return this.if[row - 1][col - 1];
    }

    public GenericFieldMatrix(F[][] data) {
        this.new = data.length;
        this.void = data[0].length;
        this.false = (Field)data[0][0].ZERO();
        this.if = (Field[][])Array.newInstance(this.false.getClass(), this.new, this.void);
        for (int a2 = 0; a2 < this.new; ++a2) {
            if (data[a2].length != this.void) {
                this.if = null;
                throw new IllegalArgumentException("data is a jagged array");
            }
            for (int a3 = 0; a3 < this.void; ++a3) {
                this.if[a2][a3] = data[a2][a3];
            }
        }
    }

    @Override
    public GenericFieldMatrix<F> scaled(F scalar) {
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.new, this.void, (Field)this.false.ZERO());
        for (int a3 = 0; a3 < this.new; ++a3) {
            for (int a4 = 0; a4 < this.void; ++a4) {
                a2.if[a3][a4] = (Field)this.if[a3][a4].multiply(scalar);
            }
        }
        return a2;
    }

    @Override
    public GenericFieldMatrix<F> minus(GenericFieldMatrix<F> that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.new, this.void, (Field)this.false.ZERO());
        for (int a3 = 0; a3 < this.new; ++a3) {
            for (int a4 = 0; a4 < this.void; ++a4) {
                a2.if[a3][a4] = (Field)this.if[a3][a4].minus(that.if[a3][a4]);
            }
        }
        return a2;
    }

    @Override
    public GenericFieldMatrix<F> opposite() {
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.new, this.void, (Field)this.false.ZERO());
        for (int a3 = 0; a3 < this.new; ++a3) {
            for (int a4 = 0; a4 < this.void; ++a4) {
                a2.if[a3][a4] = (Field)this.if[a3][a4].opposite();
            }
        }
        return a2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericFieldMatrix a2 = (GenericFieldMatrix)obj;
        if (!DimensionCheck.isSameDimension(this, a2)) {
            return false;
        }
        return this.if == a2.if || this.if != null && a2.if != null && this.final((Field[][])a2.if);
    }

    @Override
    public void set(int row, int col, F value) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        this.if[row - 1][col - 1] = value;
    }

    @Override
    public GenericFieldMatrix<F> multiply(GenericFieldMatrix<F> that) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, that);
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.new, that.void, (Field)this.false.ZERO());
        for (int a3 = 0; a3 < this.new; ++a3) {
            for (int a4 = 0; a4 < that.void; ++a4) {
                Field a5 = (Field)this.false.ZERO();
                for (int a6 = 0; a6 < this.void; ++a6) {
                    Field a7 = (Field)this.if[a3][a6].multiply(that.if[a6][a4]);
                    a5 = a5.add(a7);
                }
                a2.if[a3][a4] = a5;
            }
        }
        return a2;
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 61 * a2 + this.new;
        a2 = 61 * a2 + this.void;
        a2 = 61 * a2 + Arrays.deepHashCode(this.if);
        a2 = 61 * a2 + (this.false != null ? this.false.hashCode() : 0);
        return a2;
    }

    private boolean final(F[][] a2) {
        GenericFieldMatrix a3;
        for (int a4 = 0; a4 < a3.new; ++a4) {
            for (int a5 = 0; a5 < a3.void; ++a5) {
                if (a3.if[a4][a5].equals(a2[a4][a5])) continue;
                return false;
            }
        }
        return true;
    }
}

