/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeLinearSystemSolver;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.IdentityPreconditioner;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.PreconditionerFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.algorithm.iterative.monitor.IterationMonitor;
import dev.nm.misc.algorithm.iterative.monitor.NullMonitor;
import dev.nm.misc.algorithm.iterative.tolerance.Tolerance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BiconjugateGradientStabilizedSolver
implements IterativeLinearSystemSolver {
    private final Tolerance false;
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int void;
    private final int if;
    private final PreconditionerFactory new;

    public IterativeLinearSystemSolver.Solution solve(LSProblem problem) throws ConvergenceFailure {
        return this.solve(problem, new NullMonitor<Vector>());
    }

    @Override
    public IterativeLinearSystemSolver.Solution solve(final LSProblem problem, final IterationMonitor<Vector> monitor) throws ConvergenceFailure {
        return new IterativeLinearSystemSolver.Solution(){
            private Vector true;
            private double break;
            private Vector const;
            private boolean this;
            private final Preconditioner else;
            private double goto;
            private final Matrix try;
            private Vector float;
            private double short;
            private Vector enum;
            private final Vector false;
            private int void;
            private Vector if;
            private final int new;

            public void setInitials(Vector ... initials) {
                this.const = initials[0];
                this.if = this.false.minus(this.try.multiply(this.const));
                this.enum = this.if.deepCopy();
                this.float = this.const.ZERO();
                this.true = this.const.ZERO();
                this.this = BiconjugateGradientStabilizedSolver.this.false.isResidualSmall(this.if.norm());
            }

            @Override
            public IterationMonitor<Vector> step() throws ConvergenceFailure {
                monitor.addIterate(this.const);
                if (Double.compare(this.goto, 0.0) == 0) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.BREAKDOWN, "omega = 0");
                }
                double a2 = this.enum.innerProduct(this.if);
                if (Double.compare(a2, 0.0) == 0) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.BREAKDOWN, "<rTilde, r> = 0");
                }
                double a3 = a2 / this.short * (this.break / this.goto);
                this.float = this.if.add(this.float.minus(this.true.scaled(this.goto)).scaled(a3));
                Vector a4 = this.else.solve(this.float);
                this.true = this.try.multiply(a4);
                double a5 = this.enum.innerProduct(this.true);
                if (Double.compare(a5, 0.0) == 0) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.BREAKDOWN, "<rTilde, v> = 0");
                }
                this.break = a2 / a5;
                Vector a6 = this.if.minus(this.true.scaled(this.break));
                this.this = BiconjugateGradientStabilizedSolver.this.false.isResidualSmall(a6.norm());
                if (this.this) {
                    this.const = this.const.add(a4.scaled(this.break));
                    return monitor;
                }
                Vector a7 = this.else.solve(a6);
                Vector a8 = this.try.multiply(a7);
                this.goto = a8.innerProduct(a6) / a8.innerProduct(a8);
                this.const = this.const.add(a4.scaled(this.break)).add(a7.scaled(this.goto));
                this.if = (this.void + 1) % BiconjugateGradientStabilizedSolver.this.void != 0 ? a6.minus(a8.scaled(this.goto)) : this.false.minus(this.try.multiply(this.const));
                this.short = a2;
                return monitor;
            }
            {
                2 a3;
                a3.try = a3.problem.A();
                a3.false = a3.problem.b();
                a3.new = Math.min(a3.BiconjugateGradientStabilizedSolver.this.if, a3.try.nCols());
                a3.else = a3.BiconjugateGradientStabilizedSolver.this.new.newInstance(a3.try);
                a3.short = 1.0;
                a3.break = 1.0;
                a3.goto = 1.0;
                a3.void = 0;
            }

            @Override
            public Vector search(Vector ... initials) throws ConvergenceFailure {
                this.setInitials(initials);
                while (this.void < this.new && !this.this) {
                    this.step();
                    ++this.void;
                    this.this |= BiconjugateGradientStabilizedSolver.this.false.isResidualSmall(this.if.norm());
                }
                monitor.addIterate(this.const);
                if (!this.this) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.MAX_ITERATIONS_EXCEEDED, this.new + " iterations exceeded");
                }
                return this.const;
            }
        };
    }

    public BiconjugateGradientStabilizedSolver(int maxIteration, Tolerance tolerance) {
        this(new PreconditionerFactory(){

            @Override
            public Preconditioner newInstance(Matrix A2) {
                return new IdentityPreconditioner();
            }
            {
                1 a2;
            }
        }, 50, maxIteration, tolerance);
    }

    public BiconjugateGradientStabilizedSolver(PreconditionerFactory leftPreconditionerFactory, int residualRefreshRate, int maxIteration, Tolerance tolerance) {
        this.new = leftPreconditionerFactory;
        this.void = residualRefreshRate;
        this.if = maxIteration;
        this.false = tolerance;
    }
}

