/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.Densifiable;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseStructure;
import java.util.Comparator;
import java.util.List;

public interface SparseMatrix
extends Matrix,
Densifiable,
SparseStructure {
    public ValueArray getValueArray();

    public List<Entry> getEntryList();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ValueArray {
        private final int[] void;
        private final int[] if;
        private final double[] new;

        public int[] rowIndices() {
            return this.if;
        }

        public int[] columnIndices() {
            return this.void;
        }

        public ValueArray(int[] rowIndices, int[] columnIndices, double[] values) {
            this.if = rowIndices;
            this.void = columnIndices;
            this.new = values;
        }

        public double[] values() {
            return this.new;
        }
    }

    public static final class Entry {
        public final double value;
        public final MatrixCoordinate coordinates;

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry a2 = (Entry)obj;
            if (!(this.coordinates == a2.coordinates || this.coordinates != null && this.coordinates.equals(a2.coordinates))) {
                return false;
            }
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(a2.value);
        }

        public Entry(MatrixCoordinate coordinates, double value) {
            this.coordinates = coordinates;
            this.value = value;
        }

        public String toString() {
            return String.format("%s = %f", this.coordinates, this.value);
        }

        public int hashCode() {
            int a2 = 7;
            a2 = 83 * a2 + (this.coordinates != null ? this.coordinates.hashCode() : 0);
            a2 = 83 * a2 + (int)(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.value) >>> 32);
            return a2;
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public static enum TopLeftFirstComparator implements Comparator<Entry>
        {
            INSTANCE;


            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1.coordinates.i < o2.coordinates.i) {
                    return -1;
                }
                if (o1.coordinates.i > o2.coordinates.i) {
                    return 1;
                }
                if (o1.coordinates.j < o2.coordinates.j) {
                    return -1;
                }
                if (o1.coordinates.j > o2.coordinates.j) {
                    return 1;
                }
                return 0;
            }

            private TopLeftFirstComparator() {
                TopLeftFirstComparator a2;
            }
        }
    }
}

