/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrixUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.datastructure.Table;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LILSparseMatrix
implements SparseMatrix {
    private final int false;
    private final SparseVector[] void;
    private final int if;
    private static final MatrixMathOperation new = new AutoParallelMatrixMathOperation();

    @Override
    public LILSparseMatrix deepCopy() {
        return new LILSparseMatrix(this);
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 59 * a2 + Arrays.deepHashCode(this.void);
        a2 = 59 * a2 + this.false;
        a2 = 59 * a2 + this.if;
        return a2;
    }

    @Override
    public DenseMatrix toDense() {
        DenseMatrix a2 = new DenseMatrix(this.false, this.if).ZERO();
        int a3 = 1;
        for (SparseVector a4 : this.void) {
            for (SparseVector.Entry a5 : a4) {
                a2.set(a3, a5.index(), a5.value());
            }
            ++a3;
        }
        return a2;
    }

    private LILSparseMatrix do(LILSparseMatrix a2) {
        LILSparseMatrix a3;
        DimensionCheck.throwIfIncompatible4Multiplication((Table)a3, a2);
        Matrix a4 = a2.t();
        SparseVector[] a5 = new SparseVector[a2.if];
        for (int a6 = 0; a6 < a2.if; ++a6) {
            a5[a6] = a3.final(((LILSparseMatrix)a4).void[a6]);
        }
        return new LILSparseMatrix(a5).t();
    }

    @Override
    public LILSparseMatrix t() {
        LILSparseMatrix a2 = new LILSparseMatrix(this.if, this.false);
        for (int a3 = 0; a3 < this.false; ++a3) {
            for (SparseVector.Entry a4 : this.void[a3]) {
                a2.set(a4.index(), a3 + 1, a4.value());
            }
        }
        return a2;
    }

    @Override
    public SparseVector getColumn(int j2) {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        SparseVector a2 = new SparseVector(this.false);
        for (int a3 = 1; a3 <= this.false; ++a3) {
            double a4 = this.get(a3, j2);
            if (Double.compare(0.0, a4) == 0) continue;
            a2.set(a3, a4);
        }
        return a2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!SparseMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        LILSparseMatrix a2 = (LILSparseMatrix)obj;
        if (this.false != a2.false) {
            return false;
        }
        if (this.if != a2.if) {
            return false;
        }
        return SparseMatrixUtils.equals(this, a2);
    }

    public String toString() {
        return SparseMatrixUtils.toString(this);
    }

    public LILSparseMatrix(int nRows, int nCols, int[] rowIndices, int[] columnIndices, double[] value) {
        this(nRows, nCols);
        ArgumentAssertion.assertTrue(rowIndices.length == columnIndices.length && rowIndices.length == value.length, "input arrays size mismatch", new Object[0]);
        for (int a2 = 0; a2 < value.length; ++a2) {
            this.void[rowIndices[a2] - 1].set(columnIndices[a2], value[a2]);
        }
    }

    @Override
    public int nCols() {
        return this.if;
    }

    @Override
    public int nNonZeros() {
        int a2 = 0;
        for (SparseVector a3 : this.void) {
            a2 += a3.nNonZeros();
        }
        return a2;
    }

    @Override
    public Matrix minus(Matrix that) {
        if (that instanceof LILSparseMatrix) {
            return this.final((LILSparseMatrix)that);
        }
        return new.minus(this, that);
    }

    @Override
    public Matrix multiply(Matrix that) {
        if (that instanceof LILSparseMatrix) {
            return this.do((LILSparseMatrix)that);
        }
        return new.multiply((MatrixAccess)this, that);
    }

    @Override
    public LILSparseMatrix ONE() {
        int a2 = Math.min(this.false, this.if);
        double[] a3 = DoubleUtils.rep(1.0, a2);
        int[] a4 = DoubleUtils.seq(1, a2);
        int[] a5 = DoubleUtils.seq(1, a2);
        return new LILSparseMatrix(this.false, this.if, a4, a5, a3);
    }

    public LILSparseMatrix(int nRows, int nCols, List<SparseMatrix.Entry> entries) {
        this(nRows, nCols);
        SparseMatrixUtils.sortInRowColumnOrder(entries, nRows, nCols, true, true);
        MatrixCoordinate a2 = null;
        for (SparseMatrix.Entry a3 : entries) {
            MatrixCoordinate a4 = a3.coordinates;
            ArgumentAssertion.assertTrue(a2 == null || !a2.equals(a4), "repeated entry at coordinates %s", a4);
            a2 = a4;
            this.void[a3.coordinates.i - 1].set(a3.coordinates.j, a3.value);
        }
    }

    @Override
    public double get(int row, int col) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        return this.void[row - 1].get(col);
    }

    public LILSparseMatrix(LILSparseMatrix that) {
        this(that.false, that.if);
        for (int a2 = 0; a2 < this.false; ++a2) {
            this.void[a2] = new SparseVector(that.void[a2]);
        }
    }

    private LILSparseMatrix char(LILSparseMatrix a2) {
        LILSparseMatrix a3;
        DimensionCheck.throwIfDifferentDimension(a3, a2);
        SparseVector[] a4 = new SparseVector[a3.false];
        for (int a5 = 0; a5 < a3.false; ++a5) {
            a4[a5] = a3.void[a5].add(a2.void[a5]);
        }
        return new LILSparseMatrix(a4);
    }

    @Override
    public LILSparseMatrix scaled(double c2) {
        if (c2 == 0.0) {
            return new LILSparseMatrix(this.false, this.if);
        }
        SparseVector[] a2 = new SparseVector[this.false];
        for (int a3 = 0; a3 < this.false; ++a3) {
            a2[a3] = this.void[a3].scaled(c2);
        }
        return new LILSparseMatrix(a2);
    }

    @Override
    public Vector multiply(Vector v) {
        if (v instanceof SparseVector) {
            return this.final((SparseVector)v);
        }
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, v);
        double[] a2 = new double[this.false];
        for (int a3 = 0; a3 < this.false; ++a3) {
            a2[a3] = this.void[a3].innerProduct(v);
        }
        return new DenseVector(a2);
    }

    @Override
    public SparseMatrix.ValueArray getValueArray() {
        int a2 = this.nNonZeros();
        int[] a3 = new int[a2];
        int[] a4 = new int[a2];
        double[] a5 = new double[a2];
        int a6 = 0;
        for (int a7 = 1; a7 <= this.false; ++a7) {
            for (SparseVector.Entry a8 : this.void[a7 - 1]) {
                a3[a6] = a7;
                a4[a6] = a8.index();
                a5[a6] = a8.value();
                ++a6;
            }
        }
        return new SparseMatrix.ValueArray(a3, a4, a5);
    }

    @Override
    public LILSparseMatrix opposite() {
        return this.scaled(-1.0);
    }

    private LILSparseMatrix final(LILSparseMatrix a2) {
        LILSparseMatrix a3;
        DimensionCheck.throwIfDifferentDimension(a3, a2);
        SparseVector[] a4 = new SparseVector[a3.false];
        for (int a5 = 0; a5 < a3.false; ++a5) {
            a4[a5] = a3.void[a5].minus(a2.void[a5]);
        }
        return new LILSparseMatrix(a4);
    }

    private LILSparseMatrix(SparseVector[] a2) {
        LILSparseMatrix a3;
        a3.false = a2.length;
        a3.if = a2[0].size();
        a3.void = a2;
    }

    @Override
    public LILSparseMatrix ZERO() {
        return new LILSparseMatrix(this.false, this.if);
    }

    public LILSparseMatrix(int nRows, int nCols) {
        this.false = nRows;
        this.if = nCols;
        this.void = new SparseVector[nRows];
        for (int a2 = 0; a2 < nRows; ++a2) {
            this.void[a2] = new SparseVector(nCols);
        }
    }

    @Override
    public int nRows() {
        return this.false;
    }

    @Override
    public void set(int row, int col, double value) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        this.void[row - 1].set(col, value);
    }

    private SparseVector final(SparseVector a2) {
        LILSparseMatrix a3;
        DimensionCheck.throwIfIncompatible4Multiplication((Table)a3, a2);
        SparseVector a4 = new SparseVector(a3.false);
        double a5 = 0.0;
        for (int a6 = 0; a6 < a3.false; ++a6) {
            a5 = a3.void[a6].innerProduct(a2);
            if (Double.compare(0.0, a5) == 0) continue;
            a4.set(a6 + 1, a5);
        }
        return a4;
    }

    @Override
    public List<SparseMatrix.Entry> getEntryList() {
        ArrayList<SparseMatrix.Entry> a2 = new ArrayList<SparseMatrix.Entry>(this.nNonZeros());
        int a3 = 0;
        for (int a4 = 1; a4 <= this.false; ++a4) {
            for (SparseVector.Entry a5 : this.void[a4 - 1]) {
                a2.add(a3++, new SparseMatrix.Entry(new MatrixCoordinate(a4, a5.index()), a5.value()));
            }
        }
        return a2;
    }

    @Override
    public SparseVector getRow(int i2) {
        DimensionCheck.throwIfInvalidRow(this, i2);
        return new SparseVector(this.void[i2 - 1]);
    }

    @Override
    public Matrix add(Matrix that) {
        if (that instanceof LILSparseMatrix) {
            return this.char((LILSparseMatrix)that);
        }
        return new.add(this, that);
    }
}

