/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.triangle;

import dev.nm.algebra.linear.matrix.MatrixSingularityException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.LUDecomposition;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.PermutationMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.misc.PrecisionUtils;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.parallel.LoopBody;
import dev.nm.misc.parallel.MultipleExecutionException;
import dev.nm.misc.parallel.ParallelExecutor;
import dev.nm.number.DoubleUtils;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Doolittle
implements LUDecomposition {
    private static final int float = 100;
    private final PermutationMatrix short;
    private final LowerTriangularMatrix enum;
    private final double false;
    private final boolean void;
    private static final ParallelExecutor if = ParallelExecutor.getSharedInstance();
    private final UpperTriangularMatrix new;

    @Override
    public LowerTriangularMatrix L() {
        return this.enum.deepCopy();
    }

    private int final(double[][] a2, double[] a3, int a4, int a5) {
        int a6;
        int a7 = a6 = a5;
        double a8 = Double.NEGATIVE_INFINITY;
        for (int a9 = a6; a9 < a4; ++a9) {
            double a10 = a3[a9] * Math.abs(a2[a9][a6]);
            if (!(a10 > a8)) continue;
            a8 = a10;
            a7 = a9;
        }
        return a7;
    }

    public Doolittle(Matrix A2, boolean usePivoting) {
        this(A2, usePivoting, PrecisionUtils.autoEpsilon(A2));
    }

    public Doolittle(Matrix A2) {
        this(A2, true);
    }

    public Doolittle(Matrix A2, boolean usePivoting, double epsilon) {
        int a2;
        if (!DimensionCheck.isSquare(A2)) {
            throw new IllegalArgumentException("the LU decomposition applies to square matrix only");
        }
        this.void = usePivoting;
        this.false = epsilon;
        int a3 = A2.nRows();
        double[][] a4 = MatrixUtils.to2DArray(A2);
        int[] a5 = this.final(a4);
        double[][] a6 = new double[a3][];
        for (int a7 = 0; a7 < a3; ++a7) {
            a6[a7] = Arrays.copyOf(a4[a7], a7 + 1);
            a6[a7][a7] = 1.0;
        }
        this.enum = new LowerTriangularMatrix(a6);
        double[][] a8 = new double[a3][];
        for (a2 = 0; a2 < a3; ++a2) {
            a8[a2] = Arrays.copyOfRange(a4[a2], a2, a3);
        }
        this.new = new UpperTriangularMatrix(a8);
        this.short = new PermutationMatrix(a3);
        for (a2 = 0; a2 < a3; ++a2) {
            if (a2 == a5[a2]) continue;
            this.short.swapRow(a2 + 1, a5[a2] + 1);
        }
    }

    public Doolittle(Matrix A2, double epsilon) {
        this(A2, true, epsilon);
    }

    @Override
    public UpperTriangularMatrix U() {
        return this.new.deepCopy();
    }

    private int[] final(final double[][] a2) {
        final int a3 = a2.length;
        int[] a4 = new int[a3];
        final double[] a5 = new double[a3];
        try {
            Doolittle a6;
            if.conditionalForLoop(a3 >= 100, 0, a3, new LoopBody(){

                @Override
                public void run(int i2) throws Exception {
                    double a22 = 0.0;
                    for (int a32 = 0; a32 < a3; ++a32) {
                        double a4 = Math.abs(a2[i2][a32]);
                        if (!(a4 > a22)) continue;
                        a22 = a4;
                    }
                    a5[i2] = DoubleUtils.compare(a22, 0.0, Doolittle.this.false) == 0 ? 1.0 : 1.0 / a22;
                }
                {
                    1 a32;
                }
            });
            for (int a7 = 0; a7 < a3; ++a7) {
                int a8;
                int n = a8 = a6.void ? a6.final(a2, a5, a3, a7) : a7;
                if (a7 != a8) {
                    a6.final(a2, a3, a7, a8);
                    a5[a8] = a5[a7];
                }
                a4[a7] = a8;
                final double a9 = a2[a7][a7];
                final boolean a10 = DoubleUtils.compare(a9, 0.0, a6.false) == 0;
                final int a11 = a7;
                if.conditionalForLoop(a3 - a7 >= 100, a7 + 1, a3, new LoopBody(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run(int i2) throws Exception {
                        if (a10) {
                            if (DoubleUtils.compare(a2[i2][a11], 0.0, Doolittle.this.false) != 0) throw new MatrixSingularityException(String.format("singularity detected during the LU decomposition: column %d is almost zero (or try a bigger epsilon)", a11));
                            a2[i2][a11] = 1.0;
                        } else {
                            double[] dArray = a2[i2];
                            int n = a11;
                            dArray[n] = dArray[n] / a9;
                        }
                        double a22 = a2[i2][a11];
                        for (int a32 = a11 + 1; a32 < a3; ++a32) {
                            double[] dArray = a2[i2];
                            int n = a32;
                            dArray[n] = dArray[n] - a22 * a2[a11][a32];
                        }
                    }
                    {
                        2 a32;
                    }
                });
            }
        }
        catch (MultipleExecutionException a12) {
            for (ExecutionException a13 : a12.getExceptions()) {
                if (a13 == null || !(a13.getCause() instanceof MatrixSingularityException)) continue;
                throw (MatrixSingularityException)a13.getCause();
            }
            throw new RuntimeException("error occurred during LU decomposition", a12);
        }
        return a4;
    }

    private void final(double[][] a2, int a3, int a4, int a5) {
        for (int a6 = 0; a6 < a3; ++a6) {
            double a7 = a2[a5][a6];
            a2[a5][a6] = a2[a4][a6];
            a2[a4][a6] = a7;
        }
    }

    @Override
    public PermutationMatrix P() {
        return this.short.deepCopy();
    }
}

