/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.Hessenberg;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.HouseholderInPlace;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HessenbergDecomposition {
    private final int false;
    private Matrix void;
    private volatile Matrix if = null;
    private HouseholderInPlace new;

    public Matrix Q() {
        if (this.if == null) {
            this.if = this.new.U().t();
        }
        return this.if.deepCopy();
    }

    public Matrix H() {
        return this.void.deepCopy();
    }

    public HessenbergDecomposition(Matrix A2) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "Hessenberg Reduction applies only to square matrices", new Object[0]);
        this.false = A2.nRows();
        if (Hessenberg.isHessenberg(A2, 0.0)) {
            this.void = A2.deepCopy();
            this.if = A2.ONE();
            return;
        }
        this.new = new HouseholderInPlace(A2);
        int a2 = this.false - 2;
        for (int a3 = 1; a3 <= a2; ++a3) {
            HouseholderInPlace.Householder a4 = this.new.generateAndReflectColumns(a3, this.false, a3 + 1, this.false);
            this.new.rightReflect(a4, 1, this.false);
        }
        this.void = this.new.getTransformedMatrix();
    }
}

