/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.DefaultDeflationCriterion;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.DeflationCriterion;
import dev.nm.number.DoubleUtils;
import java.util.List;

public class Hessenberg {
    public final DeflationCriterion deflationCriterion;

    public boolean isReducible(Matrix H2, double epsilon) {
        if (!Hessenberg.isHessenberg(H2, epsilon)) {
            return false;
        }
        int a2 = H2.nRows();
        for (int a3 = 2; a3 <= a2; ++a3) {
            if (!this.deflationCriterion.isNegligible(H2, a3, a3 - 1, epsilon)) continue;
            return true;
        }
        return false;
    }

    public Hessenberg(DeflationCriterion dc) {
        this.deflationCriterion = dc;
    }

    public Hessenberg() {
        this(new DefaultDeflationCriterion());
    }

    @Deprecated
    public List<Matrix> reduce(Matrix H2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static boolean isHessenberg(Matrix H2, double epsilon) {
        int a2 = H2.nCols();
        int a3 = H2.nRows();
        for (int a4 = 1; a4 <= a2; ++a4) {
            for (int a5 = a4 + 2; a5 <= a3; ++a5) {
                if (DoubleUtils.compare(H2.get(a5, a4), 0.0, epsilon) == 0) continue;
                return false;
            }
        }
        return true;
    }
}

