/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.eigen;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.Eigen;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.EigenProperty;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import dev.nm.misc.datastructure.DimensionCheck;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EigenDecomposition {
    private final int if;
    private final Eigen new;

    public EigenDecomposition(Matrix A2) {
        this(A2, 1000.0 * PrecisionUtils.autoEpsilon(A2));
    }

    public EigenDecomposition(Matrix A2, double epsilon) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "eigen decomposition applies only to square matrices", new Object[0]);
        this.if = A2.nRows();
        Eigen.Method a2 = MatrixPropertyUtils.isSymmetric(A2, epsilon) ? Eigen.Method.MR3 : Eigen.Method.QR;
        this.new = new Eigen(A2, a2, epsilon);
    }

    public Matrix Qt() {
        return this.Q().t();
    }

    public Matrix Q() {
        ArrayList<Vector> a2 = new ArrayList<Vector>();
        for (int a3 = 0; a3 < this.new.size(); ++a3) {
            EigenProperty a4 = this.new.getProperty(a3);
            a2.addAll(a4.eigenbasis());
        }
        return MatrixFactory.cbind(a2);
    }

    public DiagonalMatrix D() {
        double[] a2 = new double[this.if];
        int a3 = 0;
        for (int a4 = 0; a4 < this.new.size(); ++a4) {
            EigenProperty a5 = this.new.getProperty(a4);
            for (int a6 = 0; a6 < a5.algebraicMultiplicity(); ++a6) {
                a2[a3++] = a5.eigenvalue().doubleValue();
            }
        }
        return new DiagonalMatrix(a2);
    }
}

